/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.JarResource;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static List<String> getPackagesFromJar(File jarFile) throws IOException {
        ArrayList<String> packageNames = new ArrayList<String>();
        if (jarFile.isDirectory()) {
            ReflectionUtil.getPackageNamesFromDir(jarFile, jarFile, packageNames);
        } else {
            JarResource resource = new JarResource();
            for (String item : resource.getJarContents(jarFile)) {
                String packageName;
                if (!item.endsWith(".class") || StringUtils.isEmpty(packageName = ReflectionUtil.getPackageName(item)) || packageNames.contains(packageName)) continue;
                packageNames.add(packageName);
            }
        }
        return packageNames;
    }

    private static void getPackageNamesFromDir(File base, File dir, List<String> pkgs) {
        boolean foundClass = false;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                ReflectionUtil.getPackageNamesFromDir(base, file, pkgs);
                continue;
            }
            if (foundClass || !file.getName().endsWith(".class")) continue;
            foundClass = true;
            String pkg = "";
            file = dir;
            while (!file.equals(base)) {
                if (!"".equals(pkg)) {
                    pkg = "." + pkg;
                }
                pkg = file.getName() + pkg;
                file = file.getParentFile();
            }
            if (pkgs.contains(pkg)) continue;
            pkgs.add(pkg);
        }
    }

    private static String getPackageName(String clzName) {
        if (clzName.indexOf("/") == -1) {
            return null;
        }
        String packageName = clzName.substring(0, clzName.lastIndexOf("/"));
        return packageName.replace("/", ".");
    }
}

