/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaAnyHandler;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.utils.CorbaAnyHelper;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;

public class CorbaAnyListener
extends AbstractCorbaTypeListener {
    private final CorbaTypeMap typeMap;
    private final ORB orb;
    private ServiceInfo serviceInfo;
    private CorbaTypeListener currentTypeListener;
    private QName containedType;
    private Map<String, String> namespaceMap;

    public CorbaAnyListener(CorbaObjectHandler h, CorbaTypeMap map, ORB orbRef, ServiceInfo info) {
        super(h);
        this.orb = orbRef;
        this.typeMap = map;
        this.serviceInfo = info;
        this.namespaceMap = new HashMap<String, String>();
    }

    public void processStartElement(QName name) {
        if (this.currentTypeListener == null) {
            this.currentElement = name;
            QName idlType = this.convertSchemaToIdlType(this.containedType);
            this.currentTypeListener = CorbaHandlerUtils.getTypeListener(name, idlType, this.typeMap, this.orb, this.serviceInfo);
            CorbaAnyHandler anyHandler = (CorbaAnyHandler)this.handler;
            anyHandler.setValue(this.orb.create_any());
            anyHandler.setAnyContainedType(this.currentTypeListener.getCorbaObject());
            this.currentTypeListener.processStartElement(name);
        } else {
            this.currentTypeListener.processStartElement(name);
        }
    }

    public void processEndElement(QName name) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processEndElement(name);
            CorbaAnyHandler anyHandler = (CorbaAnyHandler)this.handler;
            anyHandler.setAnyContainedType(this.currentTypeListener.getCorbaObject());
        }
    }

    public void processCharacters(String text) {
        if (this.currentTypeListener == null) {
            QName idlType = this.convertSchemaToIdlType(this.containedType);
            CorbaTypeListener primitiveListener = CorbaHandlerUtils.getTypeListener(idlType, idlType, this.typeMap, this.orb, this.serviceInfo);
            primitiveListener.processCharacters(text);
            CorbaObjectHandler obj = primitiveListener.getCorbaObject();
            Any a = this.orb.create_any();
            CorbaAnyHandler anyHandler = (CorbaAnyHandler)this.handler;
            anyHandler.setValue(a);
            anyHandler.setAnyContainedType(obj);
        } else {
            this.currentTypeListener.processCharacters(text);
        }
    }

    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String value) {
        if ("type".equals(localName) && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI)) {
            int index = value.lastIndexOf(58);
            if (index != -1) {
                String pfx = value.substring(0, index);
                String ns = this.namespaceMap.get(pfx);
                this.containedType = new QName(ns, value.substring(index + 1), pfx);
            } else {
                this.containedType = new QName(value);
            }
        }
    }

    public void processWriteNamespace(String prefix, String namespaceURI) {
        this.namespaceMap.put(prefix, namespaceURI);
    }

    private QName convertSchemaToIdlType(QName schemaType) {
        QName idlType = null;
        idlType = CorbaAnyHelper.isPrimitiveSchemaType(schemaType) ? CorbaAnyHelper.convertPrimitiveSchemaToIdlType(schemaType) : new QName(this.typeMap.getTargetNamespace(), schemaType.getLocalPart());
        return idlType;
    }
}

