/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.interceptors;

import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CompletionStatusHelper;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.FREE_MEM;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_FLAG;
import org.omg.CORBA.INV_IDENT;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.REBIND;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSACTION_MODE;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSACTION_UNAVAILABLE;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class SystemExceptionHelper {
    private static final int BAD_CONTEXT = 0;
    private static final int BAD_INV_ORDER = 1;
    private static final int BAD_OPERATION = 2;
    private static final int BAD_PARAM = 3;
    private static final int BAD_QOS = 4;
    private static final int BAD_TYPECODE = 5;
    private static final int CODESET_INCOMPATIBLE = 6;
    private static final int COMM_FAILURE = 7;
    private static final int DATA_CONVERSION = 8;
    private static final int FREE_MEM = 9;
    private static final int IMP_LIMIT = 10;
    private static final int INITIALIZE = 11;
    private static final int INTERNAL = 12;
    private static final int INTF_REPOS = 13;
    private static final int INVALID_TRANSACTION = 14;
    private static final int INV_FLAG = 15;
    private static final int INV_IDENT = 16;
    private static final int INV_OBJREF = 17;
    private static final int INV_POLICY = 18;
    private static final int MARSHAL = 19;
    private static final int NO_IMPLEMENT = 20;
    private static final int NO_MEMORY = 21;
    private static final int NO_PERMISSION = 22;
    private static final int NO_RESOURCES = 23;
    private static final int NO_RESPONSE = 24;
    private static final int OBJECT_NOT_EXIST = 25;
    private static final int OBJ_ADAPTER = 26;
    private static final int PERSIST_STORE = 27;
    private static final int REBIND = 28;
    private static final int TIMEOUT = 29;
    private static final int TRANSACTION_MODE = 30;
    private static final int TRANSACTION_REQUIRED = 31;
    private static final int TRANSACTION_ROLLEDBACK = 32;
    private static final int TRANSACTION_UNAVAILABLE = 33;
    private static final int TRANSIENT = 34;
    private static final int UNKNOWN = 35;
    private static final String[] CLASSES = new String[]{"org.omg.CORBA.BAD_CONTEXT", "org.omg.CORBA.BAD_INV_ORDER", "org.omg.CORBA.BAD_OPERATION", "org.omg.CORBA.BAD_PARAM", "org.omg.CORBA.BAD_QOS", "org.omg.CORBA.BAD_TYPECODE", "org.omg.CORBA.CODESET_INCOMPATIBLE", "org.omg.CORBA.COMM_FAILURE", "org.omg.CORBA.DATA_CONVERSION", "org.omg.CORBA.FREE_MEM", "org.omg.CORBA.IMP_LIMIT", "org.omg.CORBA.INITIALIZE", "org.omg.CORBA.INTERNAL", "org.omg.CORBA.INTF_REPOS", "org.omg.CORBA.INVALID_TRANSACTION", "org.omg.CORBA.INV_FLAG", "org.omg.CORBA.INV_IDENT", "org.omg.CORBA.INV_OBJREF", "org.omg.CORBA.INV_POLICY", "org.omg.CORBA.MARSHAL", "org.omg.CORBA.NO_IMPLEMENT", "org.omg.CORBA.NO_MEMORY", "org.omg.CORBA.NO_PERMISSION", "org.omg.CORBA.NO_RESOURCES", "org.omg.CORBA.NO_RESPONSE", "org.omg.CORBA.OBJECT_NOT_EXIST", "org.omg.CORBA.OBJ_ADAPTER", "org.omg.CORBA.PERSIST_STORE", "org.omg.CORBA.REBIND", "org.omg.CORBA.TIMEOUT", "org.omg.CORBA.TRANSACTION_MODE", "org.omg.CORBA.TRANSACTION_REQUIRED", "org.omg.CORBA.TRANSACTION_ROLLEDBACK", "org.omg.CORBA.TRANSACTION_UNAVAILABLE", "org.omg.CORBA.TRANSIENT", "org.omg.CORBA.UNKNOWN"};
    private static final String[] NAMES = new String[]{"BAD_CONTEXT", "BAD_INV_ORDER", "BAD_OPERATION", "BAD_PARAM", "BAD_QOS", "BAD_TYPECODE", "CODESET_INCOMPATIBLE", "COMM_FAILURE", "DATA_CONVERSION", "FREE_MEM", "IMP_LIMIT", "INITIALIZE", "INTERNAL", "INTF_REPOS", "INVALID_TRANSACTION", "INV_FLAG", "INV_IDENT", "INV_OBJREF", "INV_POLICY", "MARSHAL", "NO_IMPLEMENT", "NO_MEMORY", "NO_PERMISSION", "NO_RESOURCES", "NO_RESPONSE", "OBJECT_NOT_EXIST", "OBJ_ADAPTER", "PERSIST_STORE", "REBIND", "TIMEOUT", "TRANSACTION_MODE", "TRANSACTION_REQUIRED", "TRANSACTION_ROLLEDBACK", "TRANSACTION_UNAVAILABLE", "TRANSIENT", "UNKNOWN"};
    private static final String[] IDS = new String[]{"IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "IDL:omg.org/CORBA/BAD_OPERATION:1.0", "IDL:omg.org/CORBA/BAD_PARAM:1.0", "IDL:omg.org/CORBA/BAD_QOS:1.0", "IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "IDL:omg.org/CORBA/CODESET_INCOMPATIBLE:1.0", "IDL:omg.org/CORBA/COMM_FAILURE:1.0", "IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "IDL:omg.org/CORBA/FREE_MEM:1.0", "IDL:omg.org/CORBA/IMP_LIMIT:1.0", "IDL:omg.org/CORBA/INITIALIZE:1.0", "IDL:omg.org/CORBA/INTERNAL:1.0", "IDL:omg.org/CORBA/INTF_REPOS:1.0", "IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "IDL:omg.org/CORBA/INV_FLAG:1.0", "IDL:omg.org/CORBA/INV_IDENT:1.0", "IDL:omg.org/CORBA/INV_OBJREF:1.0", "IDL:omg.org/CORBA/INV_POLICY:1.0", "IDL:omg.org/CORBA/MARSHAL:1.0", "IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "IDL:omg.org/CORBA/NO_MEMORY:1.0", "IDL:omg.org/CORBA/NO_PERMISSION:1.0", "IDL:omg.org/CORBA/NO_RESOURCES:1.0", "IDL:omg.org/CORBA/NO_RESPONSE:1.0", "IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "IDL:omg.org/CORBA/PERSIST_STORE:1.0", "IDL:omg.org/CORBA/REBIND:1.0", "IDL:omg.org/CORBA/TIMEOUT:1.0", "IDL:omg.org/CORBA/TRANSACTION_MODE:1.0", "IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "IDL:omg.org/CORBA/TRANSACTION_UNAVAILABLE:1.0", "IDL:omg.org/CORBA/TRANSIENT:1.0", "IDL:omg.org/CORBA/UNKNOWN:1.0"};
    private static TypeCode typeCode;

    private SystemExceptionHelper() {
    }

    private static int binarySearch(String[] arr, String value) {
        int left = 0;
        int right = arr.length;
        int index = -1;
        while (left < right) {
            int m = (left + right) / 2;
            int res = arr[m].compareTo(value);
            if (res == 0) {
                index = m;
                break;
            }
            if (res > 0) {
                right = m;
                continue;
            }
            left = m + 1;
        }
        return index;
    }

    private static TypeCode createTypeCode(String id, String name) {
        ORB orb = ORB.init();
        StructMember[] members = new StructMember[2];
        members[0] = new StructMember();
        members[0].name = "minor";
        members[0].type = orb.get_primitive_tc(TCKind.tk_ulong);
        members[1] = new StructMember();
        members[1].name = "completed";
        members[1].type = CompletionStatusHelper.type();
        return orb.create_exception_tc(id, name, members);
    }

    private static void writeImpl(OutputStream out, SystemException val, String id) {
        out.write_string(id);
        out.write_ulong(val.minor);
        out.write_ulong(val.completed.value());
    }

    public static void insert(Any any, SystemException val) {
        String className = val.getClass().getName();
        int index = SystemExceptionHelper.binarySearch(CLASSES, className);
        String id = index == -1 ? IDS[35] : IDS[index];
        OutputStream out = any.create_output_stream();
        SystemExceptionHelper.writeImpl(out, val, id);
        any.read_value(out.create_input_stream(), SystemExceptionHelper.createTypeCode(id, NAMES[index]));
    }

    public static SystemException extract(Any any) {
        try {
            TypeCode tc = any.type();
            String id = tc.id();
            if (tc.kind() == TCKind.tk_except && (id.length() == 0 || SystemExceptionHelper.binarySearch(IDS, id) != -1)) {
                return SystemExceptionHelper.read(any.create_input_stream());
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        throw new BAD_OPERATION();
    }

    public static synchronized TypeCode type() {
        if (typeCode == null) {
            typeCode = SystemExceptionHelper.createTypeCode(SystemExceptionHelper.id(), "SystemException");
        }
        return typeCode;
    }

    public static String id() {
        return "IDL:omg.org/CORBA/SystemException:1.0";
    }

    public static void write(OutputStream out, SystemException val) {
        String className = val.getClass().getName();
        int index = SystemExceptionHelper.binarySearch(CLASSES, className);
        String id = index == -1 ? IDS[35] : IDS[index];
        SystemExceptionHelper.writeImpl(out, val, id);
    }

    public static SystemException read(InputStream in) {
        String id = in.read_string();
        int minor = in.read_ulong();
        CompletionStatus status = CompletionStatus.from_int((int)in.read_ulong());
        int n = SystemExceptionHelper.binarySearch(IDS, id);
        BAD_CONTEXT ex = null;
        switch (n) {
            case 0: {
                ex = new BAD_CONTEXT(minor, status);
                break;
            }
            case 1: {
                ex = new BAD_INV_ORDER(minor, status);
                break;
            }
            case 2: {
                ex = new BAD_OPERATION(minor, status);
                break;
            }
            case 3: {
                ex = new BAD_PARAM(minor, status);
                break;
            }
            case 4: {
                ex = new BAD_QOS(minor, status);
                break;
            }
            case 5: {
                ex = new BAD_TYPECODE(minor, status);
                break;
            }
            case 6: {
                ex = new CODESET_INCOMPATIBLE(minor, status);
                break;
            }
            case 7: {
                ex = new COMM_FAILURE(minor, status);
                break;
            }
            case 8: {
                ex = new DATA_CONVERSION(minor, status);
                break;
            }
            case 9: {
                ex = new FREE_MEM(minor, status);
                break;
            }
            case 10: {
                ex = new IMP_LIMIT(minor, status);
                break;
            }
            case 11: {
                ex = new INITIALIZE(minor, status);
                break;
            }
            case 12: {
                ex = new INTERNAL(minor, status);
                break;
            }
            case 13: {
                ex = new INTF_REPOS(minor, status);
                break;
            }
            case 14: {
                ex = new INVALID_TRANSACTION(minor, status);
                break;
            }
            case 15: {
                ex = new INV_FLAG(minor, status);
                break;
            }
            case 16: {
                ex = new INV_IDENT(minor, status);
                break;
            }
            case 17: {
                ex = new INV_OBJREF(minor, status);
                break;
            }
            case 18: {
                ex = new INV_POLICY(minor, status);
                break;
            }
            case 19: {
                ex = new MARSHAL(minor, status);
                break;
            }
            case 20: {
                ex = new NO_IMPLEMENT(minor, status);
                break;
            }
            case 21: {
                ex = new NO_MEMORY(minor, status);
                break;
            }
            case 22: {
                ex = new NO_PERMISSION(minor, status);
                break;
            }
            case 23: {
                ex = new NO_RESOURCES(minor, status);
                break;
            }
            case 24: {
                ex = new NO_RESPONSE(minor, status);
                break;
            }
            case 25: {
                ex = new OBJECT_NOT_EXIST(minor, status);
                break;
            }
            case 26: {
                ex = new OBJ_ADAPTER(minor, status);
                break;
            }
            case 27: {
                ex = new PERSIST_STORE(minor, status);
                break;
            }
            case 28: {
                ex = new REBIND(minor, status);
                break;
            }
            case 29: {
                ex = new TIMEOUT(minor, status);
                break;
            }
            case 30: {
                ex = new TRANSACTION_MODE(minor, status);
                break;
            }
            case 31: {
                ex = new TRANSACTION_REQUIRED(minor, status);
                break;
            }
            case 32: {
                ex = new TRANSACTION_ROLLEDBACK(minor, status);
                break;
            }
            case 33: {
                ex = new TRANSACTION_UNAVAILABLE(minor, status);
                break;
            }
            case 34: {
                ex = new TRANSIENT(minor, status);
                break;
            }
            default: {
                ex = new UNKNOWN(minor, status);
            }
        }
        return ex;
    }
}

