/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class TransportBinding
extends Binding {
    private TransportToken transportToken;
    private List<TransportBinding> transportBindings;

    public TransportBinding(SPConstants version) {
        super(version);
    }

    public TransportToken getTransportToken() {
        return this.transportToken;
    }

    public void setTransportToken(TransportToken transportToken) {
        this.transportToken = transportToken;
    }

    public List getConfigurations() {
        return this.transportBindings;
    }

    public TransportBinding getDefaultConfiguration() {
        if (this.transportBindings != null) {
            return this.transportBindings.get(0);
        }
        return null;
    }

    public void addConfiguration(TransportBinding transportBinding) {
        if (this.transportBindings == null) {
            this.transportBindings = new ArrayList<TransportBinding>();
        }
        this.transportBindings.add(transportBinding);
    }

    public QName getName() {
        return this.constants.getTransportBinding();
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List<Assertion> configurations = algorithmSuite.getConfigurations();
        if (configurations != null && configurations.size() == 1) {
            this.setNormalized(true);
            return this;
        }
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        Iterator<Assertion> iterator = configurations.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            TransportBinding transportBinding = new TransportBinding(this.constants);
            algorithmSuite = (AlgorithmSuite)iterator.next();
            transportBinding.setAlgorithmSuite(algorithmSuite);
            transportBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            transportBinding.setLayout(this.getLayout());
            transportBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            transportBinding.setSignedSupportingToken(this.getSignedSupportingToken());
            transportBinding.setTransportToken(this.getTransportToken());
            wrapper.addPolicyComponent((PolicyComponent)transportBinding);
            exactlyOne.addPolicyComponent((PolicyComponent)wrapper);
        }
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.transportToken == null) {
            throw new RuntimeException("no TransportToken found");
        }
        this.transportToken.serialize(writer);
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("no AlgorithmSuite found");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, "IncludeTimestamp", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

