/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.js.rhino;

import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.w3c.dom.Node;

public abstract class AbstractDOMProvider {
    public static final String NO_WSDL_LOCATION = "no wsdlLocation property found";
    public static final String NO_SERVICE_NAME = "no serviceName property found";
    public static final String NO_PORT_NAME = "no portName property found";
    public static final String NO_TGT_NAMESPACE = "no targetNamespace property found";
    public static final String NO_INVOKE = "no invoke property found";
    public static final String ILLEGAL_INVOKE_TYPE = "invoke property is not a Function type";
    public static final String NO_EP_ADDR = "no endpoint address specified";
    private Scriptable scriptScope;
    private Scriptable webSvcProviderVar;
    private String epAddress;
    private boolean isBaseAddr;
    private boolean isE4X;
    private Function invokeFunc;

    protected AbstractDOMProvider(Scriptable scope, Scriptable wspVar, String epAddr, boolean isBase, boolean e4x) {
        this.scriptScope = scope;
        this.webSvcProviderVar = wspVar;
        this.epAddress = epAddr;
        this.isBaseAddr = isBase;
        this.isE4X = e4x;
    }

    public void publish() throws Exception {
        String addr = this.epAddress;
        String wsdlLoc = null;
        String svcNm = null;
        String portNm = null;
        String tgtNmspc = null;
        String binding = null;
        Object obj = this.webSvcProviderVar.get("wsdlLocation", this.webSvcProviderVar);
        if (obj == Scriptable.NOT_FOUND) {
            throw new JSDOMProviderException(NO_WSDL_LOCATION);
        }
        if (obj instanceof String) {
            wsdlLoc = (String)obj;
        }
        if ((obj = this.webSvcProviderVar.get("serviceName", this.webSvcProviderVar)) == Scriptable.NOT_FOUND) {
            throw new JSDOMProviderException(NO_SERVICE_NAME);
        }
        if (obj instanceof String) {
            svcNm = (String)obj;
        }
        if ((obj = this.webSvcProviderVar.get("portName", this.webSvcProviderVar)) == Scriptable.NOT_FOUND) {
            throw new JSDOMProviderException(NO_PORT_NAME);
        }
        if (obj instanceof String) {
            portNm = (String)obj;
        }
        if ((obj = this.webSvcProviderVar.get("targetNamespace", this.webSvcProviderVar)) == Scriptable.NOT_FOUND) {
            throw new JSDOMProviderException(NO_TGT_NAMESPACE);
        }
        if (obj instanceof String) {
            tgtNmspc = (String)obj;
        }
        if (addr == null && (obj = this.webSvcProviderVar.get("EndpointAddress", this.scriptScope)) != Scriptable.NOT_FOUND && obj instanceof String) {
            addr = (String)obj;
            this.isBaseAddr = false;
        }
        if (addr == null) {
            throw new JSDOMProviderException(NO_EP_ADDR);
        }
        if (this.isBaseAddr) {
            addr = addr.endsWith("/") ? addr + portNm : addr + "/" + portNm;
        }
        if ((obj = this.webSvcProviderVar.get("BindingType", this.scriptScope)) != Scriptable.NOT_FOUND && obj instanceof String) {
            binding = (String)obj;
        }
        if ((obj = this.webSvcProviderVar.get("invoke", this.webSvcProviderVar)) == Scriptable.NOT_FOUND) {
            throw new JSDOMProviderException(NO_INVOKE);
        }
        if (!(obj instanceof Function)) {
            throw new JSDOMProviderException(ILLEGAL_INVOKE_TYPE);
        }
        this.invokeFunc = (Function)obj;
        Bus bus = BusFactory.getThreadDefaultBus();
        JaxWsServerFactoryBean factory = new JaxWsServerFactoryBean();
        factory.setWsdlLocation(wsdlLoc);
        factory.setBindingId(binding);
        factory.setServiceName(new QName(tgtNmspc, svcNm));
        factory.setEndpointName(new QName(tgtNmspc, portNm));
        EndpointImpl ep = new EndpointImpl(bus, (Object)this, factory);
        ep.publish(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMSource invoke(DOMSource request) {
        DOMSource response = new DOMSource();
        Context cx = Context.enter();
        try {
            Scriptable scope = cx.newObject(this.scriptScope);
            scope.setPrototype(this.scriptScope);
            scope.setParentScope(null);
            Node node = request.getNode();
            Scriptable inDoc = null;
            if (this.isE4X) {
                try {
                    XmlObject xo = XmlObject.Factory.parse((Node)node);
                    XmlCursor cursor = xo.newCursor();
                    do {
                        if (!cursor.isComment()) continue;
                        cursor.removeXml();
                    } while (cursor.toNextToken() != XmlCursor.TokenType.NONE);
                    cursor.dispose();
                    inDoc = Context.toObject((Object)xo, (Scriptable)scope);
                    Object[] args = new Object[]{inDoc};
                    inDoc = cx.newObject(this.scriptScope, "XML", args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                inDoc = Context.toObject((Object)node, (Scriptable)scope);
            }
            Object[] args = new Object[]{inDoc};
            Object jsResp = this.invokeFunc.call(cx, scope, scope, args);
            if (this.isE4X) {
                Scriptable s = (Scriptable)jsResp;
                Object out = ScriptableObject.callMethod((Scriptable)s, (String)"getXmlObject", (Object[])Context.emptyArgs);
                Wrapper wrapped = (Wrapper)out;
                XmlObject xml = (XmlObject)wrapped.unwrap();
                node = xml.getDomNode();
                response.setNode(node.getOwnerDocument());
            } else {
                if (jsResp instanceof Wrapper) {
                    jsResp = ((Wrapper)jsResp).unwrap();
                }
                if (jsResp instanceof Node) {
                    node = (Node)jsResp;
                    response.setNode(node);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            Context.exit();
        }
        return response;
    }

    public static class JSDOMProviderException
    extends Exception {
        public JSDOMProviderException(String reason) {
            super(reason);
        }
    }
}

