/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.concurrent.atomic.AtomicInteger;

public final class LoggingMessage {
    public static final String ID_KEY = LoggingMessage.class.getName() + ".ID";
    private static final AtomicInteger ID = new AtomicInteger();
    private final String heading;
    private final StringBuilder address;
    private final StringBuilder contentType;
    private final StringBuilder encoding;
    private final StringBuilder header;
    private final StringBuilder message;
    private final StringBuilder payload;
    private final String id;

    public LoggingMessage(String h, String i) {
        this.heading = h;
        this.id = i;
        this.contentType = new StringBuilder();
        this.address = new StringBuilder();
        this.encoding = new StringBuilder();
        this.header = new StringBuilder();
        this.message = new StringBuilder();
        this.payload = new StringBuilder();
    }

    public static String nextId() {
        return Integer.toString(ID.incrementAndGet());
    }

    public StringBuilder getAddress() {
        return this.address;
    }

    public StringBuilder getEncoding() {
        return this.encoding;
    }

    public StringBuilder getHeader() {
        return this.header;
    }

    public StringBuilder getContentType() {
        return this.contentType;
    }

    public StringBuilder getMessage() {
        return this.message;
    }

    public StringBuilder getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.heading);
        buffer.append("\nID: ").append(this.id);
        if (this.address.length() > 0) {
            buffer.append("\nAddress: ");
            buffer.append((CharSequence)this.address);
        }
        buffer.append("\nEncoding: ");
        buffer.append((CharSequence)this.encoding);
        buffer.append("\nContent-Type: ");
        buffer.append((CharSequence)this.contentType);
        buffer.append("\nHeaders: ");
        buffer.append((CharSequence)this.header);
        if (this.message.length() > 0) {
            buffer.append("\nMessages: ");
            buffer.append((CharSequence)this.message);
        }
        buffer.append("\nPayload: ");
        buffer.append((CharSequence)this.payload);
        buffer.append("\n--------------------------------------");
        return buffer.toString();
    }
}

