/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements Request {
    private final Message m;

    public RequestImpl(Message m) {
        this.m = m;
    }

    public Variant selectVariant(List<Variant> vars) throws IllegalArgumentException {
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        String ifMatch = this.getHeaderValue("If-Match");
        if (ifMatch == null || ifMatch.equals("*")) {
            return null;
        }
        try {
            EntityTag requestTag = EntityTag.valueOf((String)ifMatch);
            if (requestTag.equals((Object)eTag) && !requestTag.isWeak()) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Response.status((int)412).tag(eTag);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifModifiedSince = this.getHeaderValue("If-Modified-Since");
        if (ifModifiedSince == null) {
            return null;
        }
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        dateFormat.setLenient(false);
        Date dateSince = null;
        try {
            dateSince = dateFormat.parse(ifModifiedSince);
        }
        catch (ParseException ex) {
            return null;
        }
        if (dateSince.before(lastModified)) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder rb = this.evaluatePreconditions(eTag);
        if (rb != null) {
            return rb;
        }
        return this.evaluatePreconditions(lastModified);
    }

    private String getHeaderValue(String name) {
        Map headers = (Map)this.m.get(Message.PROTOCOL_HEADERS);
        if (headers == null) {
            return null;
        }
        List values = (List)headers.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return (String)values.get(0);
    }
}

