/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.core.Context;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceInfo {
    private boolean root;
    private Class<?> resourceClass;
    private Class<?> serviceClass;
    private List<Field> contextFields;
    private List<Field> resourceFields;
    private Map<Class<?>, Method> contextMethods;
    private Map<Field, ThreadLocalProxy> fieldProxyMap;
    private Map<Field, ThreadLocalProxy> resourceProxyMap;
    private Map<Method, ThreadLocalProxy> setterProxyMap;

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot) {
        this.serviceClass = serviceClass;
        this.resourceClass = resourceClass;
        this.root = isRoot;
        if (this.root) {
            this.initContextFields();
            this.initContextSetterMethods();
        }
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    private void initContextFields() {
        if (this.resourceClass == null || !this.root) {
            return;
        }
        for (Field f : this.getServiceClass().getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (a.annotationType() == Context.class) {
                    if (this.contextFields == null) {
                        this.contextFields = new ArrayList<Field>();
                    }
                    this.contextFields.add(f);
                    if (this.fieldProxyMap == null) {
                        this.fieldProxyMap = new HashMap<Field, ThreadLocalProxy>();
                    }
                    this.fieldProxyMap.put(f, InjectionUtils.createThreadLocalProxy(f.getType()));
                    continue;
                }
                if (a.annotationType() != Resource.class) continue;
                if (this.resourceFields == null) {
                    this.resourceFields = new ArrayList<Field>();
                }
                this.resourceFields.add(f);
                if (this.resourceProxyMap == null) {
                    this.resourceProxyMap = new HashMap<Field, ThreadLocalProxy>();
                }
                this.resourceProxyMap.put(f, InjectionUtils.createThreadLocalProxy(f.getType()));
            }
        }
    }

    private void initContextSetterMethods() {
        block0: for (Method m : this.getServiceClass().getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (a.annotationType() != Context.class) continue;
                this.checkContextMethod(m);
                continue block0;
            }
        }
    }

    private void checkContextMethod(Method m) {
        Class<?> type = m.getParameterTypes()[0];
        if (AnnotationUtils.isContextClass(type) && m.getName().equals("set" + type.getSimpleName())) {
            this.addContextMethod(type, m);
        }
    }

    public Map<Class<?>, Method> getContextMethods() {
        return this.contextMethods == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.contextMethods);
    }

    private void addContextMethod(Class<?> contextClass, Method m) {
        if (this.contextMethods == null) {
            this.contextMethods = new HashMap();
        }
        this.contextMethods.put(contextClass, m);
        if (this.setterProxyMap == null) {
            this.setterProxyMap = new HashMap<Method, ThreadLocalProxy>();
        }
        this.setterProxyMap.put(m, InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]));
    }

    public boolean isRoot() {
        return this.root;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Field> getContextFields() {
        return AbstractResourceInfo.getList(this.contextFields);
    }

    public List<Field> getResourceFields() {
        return AbstractResourceInfo.getList(this.resourceFields);
    }

    private static List<Field> getList(List<Field> fields) {
        List<Field> ret = fields != null ? Collections.unmodifiableList(fields) : Collections.emptyList();
        return ret;
    }

    public ThreadLocalProxy getContextFieldProxy(Field f) {
        return this.fieldProxyMap == null ? null : this.fieldProxyMap.get(f);
    }

    public ThreadLocalProxy getResourceFieldProxy(Field f) {
        return this.resourceProxyMap == null ? null : this.resourceProxyMap.get(f);
    }

    public ThreadLocalProxy getContextSetterProxy(Method m) {
        return this.setterProxyMap == null ? null : this.setterProxyMap.get(m);
    }

    public abstract boolean isSingleton();

    public void clearThreadLocalProxies() {
        AbstractResourceInfo.clearProxies(this.fieldProxyMap);
        AbstractResourceInfo.clearProxies(this.resourceProxyMap);
        AbstractResourceInfo.clearProxies(this.setterProxyMap);
    }

    private static void clearProxies(Map<?, ThreadLocalProxy> tlps) {
        if (tlps == null) {
            return;
        }
        for (ThreadLocalProxy tlp : tlps.values()) {
            if (tlp == null) continue;
            tlp.remove();
        }
    }
}

