/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.JMSTransport;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.transport.jms.ServerBehaviorPolicyType;
import org.apache.cxf.transport.jms.ServerConfig;

public final class JMSProviderHub {
    private JMSProviderHub() {
    }

    public String toString() {
        return "JMSProviderHub";
    }

    protected static void connect(JMSTransport jmsTransport) throws JMSException, NamingException {
        JMSProviderHub.connect(jmsTransport, null, null);
    }

    protected static void connect(JMSTransport jmsTransport, ServerConfig jmsDestConfigBean, ServerBehaviorPolicyType runtimePolicy) throws JMSException, NamingException {
        String clientID;
        AddressType addrDetails = jmsTransport.getJMSAddress();
        boolean isQueue = "queue".equals(addrDetails.getDestinationStyle().value());
        Context context = JMSUtils.getInitialContext(addrDetails);
        QueueConnection connection = null;
        if (isQueue) {
            QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(addrDetails.getJndiConnectionFactoryName());
            connection = addrDetails.isSetConnectionUserName() ? qcf.createQueueConnection(addrDetails.getConnectionUserName(), addrDetails.getConnectionPassword()) : qcf.createQueueConnection();
        } else {
            TopicConnectionFactory tcf = (TopicConnectionFactory)context.lookup(addrDetails.getJndiConnectionFactoryName());
            connection = addrDetails.isSetConnectionUserName() ? tcf.createTopicConnection(addrDetails.getConnectionUserName(), addrDetails.getConnectionPassword()) : tcf.createTopicConnection();
        }
        if (null != jmsDestConfigBean && (clientID = jmsDestConfigBean.getDurableSubscriptionClientId()) != null) {
            connection.setClientID(clientID);
        }
        connection.start();
        Object requestDestination = null;
        if (addrDetails.getJndiDestinationName() != null) {
            requestDestination = (Destination)context.lookup(addrDetails.getJndiDestinationName());
        }
        if (requestDestination == null && addrDetails.getJmsDestinationName() != null) {
            requestDestination = isQueue ? connection.createSession(false, 1).createQueue(addrDetails.getJmsDestinationName()) : connection.createSession(false, 1).createTopic(addrDetails.getJmsDestinationName());
        }
        if (requestDestination == null) {
            throw new JMSException("Failed to lookup or create requestDestination");
        }
        Destination replyDestination = null;
        if (isQueue) {
            if (addrDetails.getJndiReplyDestinationName() != null) {
                replyDestination = (Destination)context.lookup(addrDetails.getJndiReplyDestinationName());
            }
            if (replyDestination == null && addrDetails.getJmsReplyDestinationName() != null) {
                replyDestination = connection.createSession(false, 1).createQueue(addrDetails.getJmsReplyDestinationName());
            }
        }
        JMSSessionFactory sf = new JMSSessionFactory((Connection)connection, replyDestination, context, jmsTransport, runtimePolicy);
        jmsTransport.connected((Destination)requestDestination, replyDestination, sf);
    }
}

