/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import javax.jms.MessageListener;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class JMSListenerPoolableObjectFactory
implements PoolableObjectFactory {
    private JMSConfiguration jmsConfig;
    private MessageListener handler;

    public JMSListenerPoolableObjectFactory(JMSConfiguration jmsConfig, MessageListener handler) {
        this.jmsConfig = jmsConfig;
        this.handler = handler;
    }

    public void activateObject(Object obj) throws Exception {
        DefaultMessageListenerContainer listener = (DefaultMessageListenerContainer)obj;
        listener.start();
    }

    public void destroyObject(Object obj) throws Exception {
        DefaultMessageListenerContainer listener = (DefaultMessageListenerContainer)obj;
        listener.destroy();
    }

    public Object makeObject() throws Exception {
        DefaultMessageListenerContainer obj;
        DefaultMessageListenerContainer listener = obj = JMSFactory.createJmsListener(this.jmsConfig, this.handler, this.jmsConfig.getReplyDestination(), null, false);
        listener.setCacheLevel(2);
        return listener;
    }

    public void passivateObject(Object obj) throws Exception {
        DefaultMessageListenerContainer listener = (DefaultMessageListenerContainer)obj;
        listener.stop();
    }

    public boolean validateObject(Object obj) {
        DefaultMessageListenerContainer listener = (DefaultMessageListenerContainer)obj;
        return listener.isActive();
    }
}

