/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;

public final class WSActionAnnotator
implements Annotator {
    private static final QName WSAW_ACTION_QNAME = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action");
    private static final QName WSAM_ACTION_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "Action");
    private static final QName WSAW_OLD_ACTION_QNAME = new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action");
    private OperationInfo operation;

    public WSActionAnnotator(OperationInfo op) {
        this.operation = op;
    }

    private String getAction(AbstractMessageContainer mi) {
        QName action = (QName)mi.getExtensionAttribute(WSAW_ACTION_QNAME);
        if (action == null) {
            action = (QName)mi.getExtensionAttribute(WSAM_ACTION_QNAME);
        }
        if (action == null) {
            action = (QName)mi.getExtensionAttribute(WSAW_OLD_ACTION_QNAME);
        }
        if (action != null) {
            return action.getLocalPart();
        }
        return null;
    }

    public void annotate(JavaAnnotatable ja) {
        String outputAction;
        String inputAction;
        if (!(ja instanceof JavaMethod)) {
            throw new RuntimeException("Action can only annotate JavaMethod");
        }
        JavaMethod method = (JavaMethod)ja;
        boolean required = false;
        JavaInterface intf = method.getInterface();
        MessageInfo inputMessage = this.operation.getInput();
        MessageInfo outputMessage = this.operation.getOutput();
        JAnnotation actionAnnotation = new JAnnotation(Action.class);
        if (inputMessage.getExtensionAttributes() != null && (inputAction = this.getAction(inputMessage)) != null) {
            actionAnnotation.addElement(new JAnnotationElement("input", inputAction));
            required = true;
        }
        if (outputMessage != null && outputMessage.getExtensionAttributes() != null && (outputAction = this.getAction(outputMessage)) != null) {
            actionAnnotation.addElement(new JAnnotationElement("output", outputAction));
            required = true;
        }
        if (this.operation.hasFaults()) {
            ArrayList<JAnnotation> faultAnnotations = new ArrayList<JAnnotation>();
            for (FaultInfo faultInfo : this.operation.getFaults()) {
                String faultAction;
                if (faultInfo.getExtensionAttributes() == null || (faultAction = this.getAction(faultInfo)) == null) continue;
                JavaException exceptionClass = this.getExceptionClass(method, faultInfo);
                if (!StringUtils.isEmpty(exceptionClass.getPackageName()) && !exceptionClass.getPackageName().equals(intf.getPackageName())) {
                    intf.addImport(exceptionClass.getClassName());
                }
                JAnnotation faultAnnotation = new JAnnotation(FaultAction.class);
                faultAnnotation.addElement(new JAnnotationElement("className", exceptionClass));
                faultAnnotation.addElement(new JAnnotationElement("value", faultAction));
                faultAnnotations.add(faultAnnotation);
                required = true;
            }
            actionAnnotation.addElement(new JAnnotationElement("fault", faultAnnotations));
        }
        if (required) {
            method.addAnnotation("Action", actionAnnotation);
        }
    }

    private JavaException getExceptionClass(JavaMethod method, FaultInfo faultInfo) {
        for (JavaException exception : method.getExceptions()) {
            QName faultName = faultInfo.getName();
            if (!exception.getTargetNamespace().equals(faultName.getNamespaceURI()) || !exception.getName().toLowerCase().startsWith(faultName.getLocalPart().toLowerCase())) continue;
            return exception;
        }
        return null;
    }
}

