/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.ext.SystemQueryHandler;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JSONProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final ProviderFactory SHARED_FACTORY = new ProviderFactory();
    private List<ProviderInfo<MessageBodyReader>> messageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> messageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();
    private List<ProviderInfo<ContextResolver>> contextResolvers = new ArrayList<ProviderInfo<ContextResolver>>(1);
    private List<ProviderInfo<ExceptionMapper>> exceptionMappers = new ArrayList<ProviderInfo<ExceptionMapper>>(1);
    private List<ProviderInfo<RequestHandler>> requestHandlers = new ArrayList<ProviderInfo<RequestHandler>>(1);
    private List<ProviderInfo<ResponseHandler>> responseHandlers = new ArrayList<ProviderInfo<ResponseHandler>>(1);
    private List<ProviderInfo<ParameterHandler>> paramHandlers = new ArrayList<ProviderInfo<ParameterHandler>>(1);
    private List<ProviderInfo<ResponseExceptionMapper>> responseExceptionMappers = new ArrayList<ProviderInfo<ResponseExceptionMapper>>(1);
    private RequestPreprocessor requestPreprocessor;

    private ProviderFactory() {
    }

    public static ProviderFactory getInstance() {
        return new ProviderFactory();
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().get(Endpoint.class);
        return (ProviderFactory)e.get(ProviderFactory.class.getName());
    }

    public static ProviderFactory getSharedInstance() {
        return SHARED_FACTORY;
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        Object mt = m.get("Content-Type");
        return this.createContextResolver(contextType, m, mt == null ? MediaType.valueOf((String)"*/*") : MediaType.valueOf((String)mt.toString()));
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType mt) {
        for (ProviderInfo<ContextResolver> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (contextType != args[i]) continue;
                    InjectionUtils.injectContextFields(cr.getProvider(), cr, m);
                    InjectionUtils.injectContextMethods(cr.getProvider(), cr, m);
                    return cr.getProvider();
                }
            }
        }
        return null;
    }

    public <T> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        ExceptionMapper<T> mapper = this.doCreateExceptionMapper(exceptionType, m);
        if (mapper != null || this == SHARED_FACTORY) {
            return mapper;
        }
        return SHARED_FACTORY.createExceptionMapper(exceptionType, m);
    }

    private <T> ExceptionMapper<T> doCreateExceptionMapper(Class<?> exceptionType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ExceptionMapper> em : this.exceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, exceptionType, m);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ExceptionMapperComparator());
        return (ExceptionMapper)candidates.get(0);
    }

    public <T> ParameterHandler<T> createParameterHandler(Class<?> paramType) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ParameterHandler> em : this.paramHandlers) {
            ProviderFactory.handleMapper(candidates, em, paramType, null);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ParameterHandlerComparator());
        return (ParameterHandler)candidates.get(0);
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Class<?> paramType) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ResponseExceptionMapper> em : this.responseExceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, paramType, null);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ResponseExceptionMapperComparator());
        return (ResponseExceptionMapper)candidates.get(0);
    }

    private static void handleMapper(List<Object> candidates, ProviderInfo em, Class<?> expectedType, Message m) {
        Type[] types;
        block0: for (Type t : types = em.getProvider().getClass().getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            Type[] args = pt.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                if (!((Class)args[i]).isAssignableFrom(expectedType)) continue;
                if (m != null) {
                    InjectionUtils.injectContextFields(em.getProvider(), em, m);
                    InjectionUtils.injectContextMethods(em.getProvider(), em, m);
                }
                candidates.add(em.getProvider());
                continue block0;
            }
        }
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr != null || this == SHARED_FACTORY) {
            return mr;
        }
        return SHARED_FACTORY.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    public List<ProviderInfo<RequestHandler>> getRequestHandlers() {
        if (this.requestHandlers.size() == 0) {
            return Collections.unmodifiableList(ProviderFactory.SHARED_FACTORY.requestHandlers);
        }
        ArrayList<ProviderInfo<RequestHandler>> handlers = new ArrayList<ProviderInfo<RequestHandler>>(ProviderFactory.SHARED_FACTORY.requestHandlers);
        handlers.addAll(this.requestHandlers);
        return handlers;
    }

    public List<ProviderInfo<ResponseHandler>> getResponseHandlers() {
        return Collections.unmodifiableList(this.responseHandlers);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw != null || this == SHARED_FACTORY) {
            return mw;
        }
        return SHARED_FACTORY.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    private void setProviders(Object ... providers) {
        for (Object o : providers) {
            if (o == null) continue;
            if (MessageBodyReader.class.isAssignableFrom(o.getClass())) {
                this.messageReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)o));
            }
            if (MessageBodyWriter.class.isAssignableFrom(o.getClass())) {
                this.messageWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)o));
            }
            if (ContextResolver.class.isAssignableFrom(o.getClass())) {
                this.contextResolvers.add(new ProviderInfo<ContextResolver>((ContextResolver)o));
            }
            if (RequestHandler.class.isAssignableFrom(o.getClass())) {
                this.requestHandlers.add(new ProviderInfo<RequestHandler>((RequestHandler)o));
            }
            if (ResponseHandler.class.isAssignableFrom(o.getClass())) {
                this.responseHandlers.add(new ProviderInfo<ResponseHandler>((ResponseHandler)o));
            }
            if (ExceptionMapper.class.isAssignableFrom(o.getClass())) {
                this.exceptionMappers.add(new ProviderInfo<ExceptionMapper>((ExceptionMapper)o));
            }
            if (ResponseExceptionMapper.class.isAssignableFrom(o.getClass())) {
                this.responseExceptionMappers.add(new ProviderInfo<ResponseExceptionMapper>((ResponseExceptionMapper)o));
            }
            if (!ParameterHandler.class.isAssignableFrom(o.getClass())) continue;
            this.paramHandlers.add(new ProviderInfo<ParameterHandler>((ParameterHandler)o));
        }
        this.sortReaders();
        this.sortWriters();
        this.injectContexts(this.messageReaders, this.messageWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers);
    }

    void injectContexts(List<?> ... providerLists) {
        for (List<?> list : providerLists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                InjectionUtils.injectContextProxies(pi, pi.getProvider());
            }
        }
    }

    private void sortReaders() {
        Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
    }

    private void sortWriters() {
        Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        for (ProviderInfo<MessageBodyReader> ep : this.messageReaders) {
            InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
            InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
            if (!this.matchesReaderCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            return ep.getProvider();
        }
        return null;
    }

    private <T> boolean matchesReaderCriterias(MessageBodyReader<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!ep.isReadable(type, genericType, annotations)) {
            return false;
        }
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
        return availableMimeTypes.size() != 0;
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        for (ProviderInfo<MessageBodyWriter> ep : this.messageWriters) {
            InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
            InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
            if (!this.matchesWriterCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            return ep.getProvider();
        }
        return null;
    }

    private <T> boolean matchesWriterCriterias(MessageBodyWriter<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!ep.isWriteable(type, genericType, annotations)) {
            return false;
        }
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
        return availableMimeTypes.size() != 0;
    }

    List<ProviderInfo<MessageBodyReader>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(userProviders.toArray());
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers);
    }

    void clearProxies(List<?> ... lists) {
        for (List<?> list : lists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                pi.clearThreadLocalProxies();
            }
        }
    }

    void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.exceptionMappers.clear();
        this.requestHandlers.clear();
        this.responseHandlers.clear();
        this.paramHandlers.clear();
        this.responseExceptionMappers.clear();
    }

    public void setSchemaLocations(List<String> schemas) {
        for (ProviderInfo<MessageBodyReader> r : this.messageReaders) {
            try {
                Method m = r.getProvider().getClass().getMethod("setSchemas", List.class);
                m.invoke((Object)r.getProvider(), schemas);
            }
            catch (Exception ex) {}
        }
    }

    private static int compareClasses(Class<?> cl1, Class<?> cl2) {
        Class<?> realClass2;
        Type[] types1 = cl1.getGenericInterfaces();
        Type[] types2 = cl2.getGenericInterfaces();
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    static {
        JSONProvider jsonProvider = null;
        try {
            jsonProvider = new JSONProvider();
        }
        catch (Throwable ex) {
            String message = "Problem with instantiating the default JSON provider, ";
            message = ex.getMessage() != null ? message + ex.getMessage() : message + "exception class : " + ex.getClass().getName();
            LOG.info(message);
        }
        SHARED_FACTORY.setProviders(new JAXBElementProvider(), jsonProvider, new BinaryDataProvider(), new SourceProvider(), new FormEncodingProvider(), new PrimitiveTextProvider(), new MultipartProvider(), new WebApplicationExceptionMapper(), new SystemQueryHandler());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterHandlerComparator
    implements Comparator<ParameterHandler<? extends Object>> {
        private ParameterHandlerComparator() {
        }

        @Override
        public int compare(ParameterHandler<? extends Object> em1, ParameterHandler<? extends Object> em2) {
            return ProviderFactory.compareClasses(em1.getClass(), em2.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResponseExceptionMapperComparator
    implements Comparator<ResponseExceptionMapper<? extends Throwable>> {
        private ResponseExceptionMapperComparator() {
        }

        @Override
        public int compare(ResponseExceptionMapper<? extends Throwable> em1, ResponseExceptionMapper<? extends Throwable> em2) {
            return ProviderFactory.compareClasses(em1.getClass(), em2.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionMapperComparator
    implements Comparator<ExceptionMapper<? extends Throwable>> {
        private ExceptionMapperComparator() {
        }

        @Override
        public int compare(ExceptionMapper<? extends Throwable> em1, ExceptionMapper<? extends Throwable> em2) {
            return ProviderFactory.compareClasses(em1.getClass(), em2.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter> p1, ProviderInfo<MessageBodyWriter> p2) {
            MessageBodyWriter e1 = p1.getProvider();
            MessageBodyWriter e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1));
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2));
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader> p1, ProviderInfo<MessageBodyReader> p2) {
            MessageBodyReader e1 = p1.getProvider();
            MessageBodyReader e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            types2 = JAXRSUtils.sortMediaTypes(types2);
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }
}

