/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.DeferredConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.v200408.EndpointReferenceType;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.CreateSequenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Expires;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.OfferType;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.TerminateSequenceType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy {
    private static final Logger LOG = LogUtils.getL7dLogger(Proxy.class);
    private RMEndpoint reliableEndpoint;
    private Identifier offeredIdentifier;

    public Proxy(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    RMEndpoint getReliableEndpoint() {
        return this.reliableEndpoint;
    }

    void acknowledge(DestinationSequence ds) throws RMException {
        if (RMConstants.getAnonymousAddress().equals(ds.getAcksTo().getAddress().getValue())) {
            LOG.log(Level.WARNING, "STANDALONE_ANON_ACKS_NOT_SUPPORTED");
            return;
        }
        OperationInfo oi = this.reliableEndpoint.getEndpoint().getEndpointInfo().getService().getInterface().getOperation(RMConstants.getSequenceAckOperationName());
        this.invoke(oi, new Object[0], null);
    }

    void terminate(SourceSequence ss) throws RMException {
        OperationInfo oi = this.reliableEndpoint.getEndpoint().getEndpointInfo().getService().getInterface().getOperation(RMConstants.getTerminateSequenceOperationName());
        TerminateSequenceType ts = RMUtils.getWSRMFactory().createTerminateSequenceType();
        ts.setIdentifier(ss.getIdentifier());
        this.invoke(oi, new Object[]{ts}, null);
    }

    void createSequenceResponse(CreateSequenceResponseType createResponse) throws RMException {
        LOG.fine("sending CreateSequenceResponse from client side");
        OperationInfo oi = this.reliableEndpoint.getEndpoint().getEndpointInfo().getService().getInterface().getOperation(RMConstants.getCreateSequenceResponseOnewayOperationName());
        this.invoke(oi, new Object[]{createResponse}, null);
    }

    public CreateSequenceResponseType createSequence(EndpointReferenceType defaultAcksTo, RelatesToType relatesTo, boolean isServer) throws RMException {
        OperationInfo oi;
        SourcePolicyType sp = this.reliableEndpoint.getManager().getSourcePolicy();
        final CreateSequenceType create = RMUtils.getWSRMFactory().createCreateSequenceType();
        String address = sp.getAcksTo();
        EndpointReferenceType acksTo = null;
        acksTo = null != address ? RMUtils.createReference2004(address) : defaultAcksTo;
        create.setAcksTo(acksTo);
        Duration d = sp.getSequenceExpiration();
        if (null != d) {
            Expires expires = RMUtils.getWSRMFactory().createExpires();
            expires.setValue(d);
            create.setExpires(expires);
        }
        if (sp.isIncludeOffer()) {
            OfferType offer = RMUtils.getWSRMFactory().createOfferType();
            d = sp.getOfferedSequenceExpiration();
            if (null != d) {
                Expires expires = RMUtils.getWSRMFactory().createExpires();
                expires.setValue(d);
                offer.setExpires(expires);
            }
            offer.setIdentifier(this.reliableEndpoint.getSource().generateSequenceIdentifier());
            create.setOffer(offer);
            this.setOfferedIdentifier(offer);
        }
        InterfaceInfo ii = this.reliableEndpoint.getEndpoint().getEndpointInfo().getService().getInterface();
        OperationInfo operationInfo = oi = isServer ? ii.getOperation(RMConstants.getCreateSequenceOnewayOperationName()) : ii.getOperation(RMConstants.getCreateSequenceOperationName());
        if (isServer) {
            LOG.fine("sending CreateSequenceRequest from server side");
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        Proxy.this.invoke(oi, new Object[]{create}, null);
                    }
                    catch (RMException rMException) {
                        // empty catch block
                    }
                }
            };
            this.reliableEndpoint.getApplicationEndpoint().getExecutor().execute(r);
            return null;
        }
        return (CreateSequenceResponseType)this.invoke(oi, new Object[]{create}, null);
    }

    void lastMessage(SourceSequence s) throws RMException {
        org.apache.cxf.ws.addressing.EndpointReferenceType target = s.getTarget();
        AttributedURIType uri = null;
        if (null != target) {
            uri = target.getAddress();
        }
        String addr = null;
        if (null != uri) {
            addr = uri.getValue();
        }
        if (addr == null) {
            LOG.log(Level.WARNING, "STANDALONE_LAST_MESSAGE_NO_TARGET_MSG");
            return;
        }
        if (RMUtils.getAddressingConstants().getAnonymousURI().equals(addr)) {
            LOG.log(Level.WARNING, "STANDALONE_LAST_MESSAGE_ANON_TARGET_MSG");
            return;
        }
        OperationInfo oi = this.reliableEndpoint.getEndpoint().getEndpointInfo().getService().getInterface().getOperation(RMConstants.getLastMessageOperationName());
        Map<String, Object> context = Collections.singletonMap(SourceSequence.class.getName(), s);
        this.invoke(oi, new Object[0], context);
    }

    void ackRequested(SourceSequence s) throws RMException {
        org.apache.cxf.ws.addressing.EndpointReferenceType target = s.getTarget();
        AttributedURIType uri = null;
        if (null != target) {
            uri = target.getAddress();
        }
        String addr = null;
        if (null != uri) {
            addr = uri.getValue();
        }
        if (addr == null) {
            LOG.log(Level.WARNING, "STANDALONE_ACK_REQUESTED_NO_TARGET_MSG");
            return;
        }
        if (RMUtils.getAddressingConstants().getAnonymousURI().equals(addr)) {
            LOG.log(Level.WARNING, "STANDALONE_ACK_REQUESTED_ANON_TARGET_MSG");
            return;
        }
        OperationInfo oi = this.reliableEndpoint.getEndpoint().getEndpointInfo().getService().getInterface().getOperation(RMConstants.getAckRequestedOperationName());
        this.invoke(oi, new Object[0], null);
    }

    Identifier getOfferedIdentifier() {
        return this.offeredIdentifier;
    }

    void setOfferedIdentifier(OfferType offer) {
        if (offer != null) {
            this.offeredIdentifier = offer.getIdentifier();
        }
    }

    Object invoke(OperationInfo oi, Object[] params, Map<String, Object> context) throws RMException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Sending out-of-band RM protocol message {0}.", oi == null ? null : oi.getName());
        }
        RMManager manager = this.reliableEndpoint.getManager();
        Bus bus = manager.getBus();
        Endpoint endpoint = this.reliableEndpoint.getEndpoint();
        BindingInfo bi = this.reliableEndpoint.getBindingInfo();
        Conduit c = this.reliableEndpoint.getConduit();
        org.apache.cxf.ws.addressing.EndpointReferenceType replyTo = this.reliableEndpoint.getReplyTo();
        Client client = this.createClient(bus, endpoint, c, replyTo);
        BindingOperationInfo boi = bi.getOperation(oi);
        try {
            Object[] result = client.invoke(boi, params, context);
            if (result != null && result.length > 0) {
                return result[0];
            }
        }
        catch (Exception ex) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("SEND_PROTOCOL_MSG_FAILED_EXC", LOG, oi == null ? null : oi.getName());
            LOG.log(Level.SEVERE, msg.toString(), ex);
            throw new RMException(msg, (Throwable)ex);
        }
        return null;
    }

    protected Client createClient(Bus bus, Endpoint endpoint, Conduit conduit, final org.apache.cxf.ws.addressing.EndpointReferenceType address) {
        DeferredConduitSelector cs = new DeferredConduitSelector(conduit){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized Conduit selectConduit(Message message) {
                Conduit conduit = null;
                EndpointInfo endpointInfo = this.getEndpoint().getEndpointInfo();
                org.apache.cxf.ws.addressing.EndpointReferenceType original = endpointInfo.getTarget();
                try {
                    if (null != address) {
                        endpointInfo.setAddress(address);
                    }
                    conduit = super.selectConduit(message);
                }
                finally {
                    endpointInfo.setAddress(original);
                }
                return conduit;
            }
        };
        return new RMClient(bus, endpoint, cs);
    }

    void setReliableEndpoint(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    class RMClient
    extends ClientImpl {
        RMClient(Bus bus, Endpoint endpoint, ConduitSelector cs) {
            super(bus, endpoint, cs);
        }

        public void onMessage(Message m) {
            m.getExchange().put(Endpoint.class, Proxy.this.reliableEndpoint.getApplicationEndpoint());
            super.onMessage(m);
        }
    }
}

