/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.Wrapper;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.WrapperUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestWrapper
extends Wrapper {
    @Override
    public void setOperationInfo(OperationInfo op) {
        super.setOperationInfo(op);
        this.setName(op.getInput().getMessageParts().get(0).getElementQName());
        this.setClassName((String)op.getInput().getMessageParts().get(0).getProperty("REQUEST.WRAPPER.CLASSNAME"));
    }

    @Override
    public boolean isWrapperAbsent(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        return this.getClassName() == null && (reqWrapper == null || StringUtils.isEmpty(reqWrapper.className()));
    }

    public String getWrapperTns(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        if (reqWrapper != null) {
            return reqWrapper.targetNamespace();
        }
        return null;
    }

    @Override
    protected List<JavaField> buildFields() {
        return this.buildFields(this.getMethod(), this.getOperationInfo().getUnwrappedOperation().getInput());
    }

    protected List<JavaField> buildFields(Method method, MessageInfo message) {
        ArrayList<JavaField> fields = new ArrayList<JavaField>();
        String type = "Object";
        Type[] paramClasses = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (MessagePartInfo mpi : message.getMessageParts()) {
            ParameterizedType pt;
            int idx = mpi.getIndex();
            String name = mpi.getName().getLocalPart();
            Type t = paramClasses[idx];
            Class clz = null;
            if (t instanceof Class) {
                clz = (Class)t;
                type = clz.isArray() ? (this.isBuiltInTypes(clz.getComponentType()) ? clz.getComponentType().getSimpleName() + "[]" : clz.getComponentType().getName() + "[]") : clz.getName();
            } else if (t instanceof ParameterizedType && (pt = (ParameterizedType)t).getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                clz = (Class)pt.getActualTypeArguments()[0];
                type = clz.getName();
            }
            JavaField field = new JavaField(name, type, "");
            if (paramAnnotations != null && paramAnnotations.length == paramClasses.length) {
                WebParam wParam = this.getWebParamAnnotation(paramAnnotations[idx]);
                if (wParam != null && !StringUtils.isEmpty(wParam.targetNamespace())) {
                    field.setTargetNamespace(wParam.targetNamespace());
                } else {
                    field.setTargetNamespace("");
                }
            }
            List<Annotation> jaxbAnns = WrapperUtil.getJaxbAnnotations(method, idx);
            field.setJaxbAnnotations(jaxbAnns.toArray(new Annotation[jaxbAnns.size()]));
            fields.add(field);
        }
        return fields;
    }

    private WebParam getWebParamAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof WebParam)) continue;
            return (WebParam)annotation;
        }
        return null;
    }

    @Override
    public WrapperBeanClass getWrapperBeanClass(Method method) {
        javax.xml.ws.RequestWrapper reqWrapper = method.getAnnotation(javax.xml.ws.RequestWrapper.class);
        String reqClassName = this.getClassName();
        String reqNs = null;
        if (reqWrapper != null) {
            reqClassName = reqWrapper.className().length() > 0 ? reqWrapper.className() : reqClassName;
            String string = reqNs = reqWrapper.targetNamespace().length() > 0 ? reqWrapper.targetNamespace() : null;
        }
        if (reqClassName == null) {
            reqClassName = this.getPackageName(method) + ".jaxws." + StringUtils.capitalize(method.getName());
        }
        WrapperBeanClass jClass = new WrapperBeanClass();
        jClass.setFullClassName(reqClassName);
        jClass.setNamespace(reqNs);
        return jClass;
    }
}

