/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.binding.corba.wsdl.BindingType;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopeNameCollection;
import org.apache.cxf.tools.corba.processors.idl.ScopedNameVisitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectReferenceVisitor
extends VisitorBase {
    private WSDLASTVisitor objRefWsdlVisitor;

    public ObjectReferenceVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.objRefWsdlVisitor = wsdlVisitor;
    }

    public static boolean accept(Scope scope, XmlSchema s, Definition def, AST node, WSDLASTVisitor wsdlVisitor) {
        boolean result = false;
        if (node.getType() == 53) {
            result = true;
        } else if (node.getType() == 17 && ObjectReferenceVisitor.hasBinding(scope, s, def, node, wsdlVisitor)) {
            result = true;
        }
        return result;
    }

    public void visit(AST node) {
        if (!this.objRefWsdlVisitor.getDeclaredWSAImport()) {
            this.addWSAddressingImport(this.schema);
        }
        this.objRefWsdlVisitor.setDeclaredWSAImport(true);
        if (ObjectReferenceVisitor.isForwardDeclaredReference(this.getScope(), this.schema, node, scopedNames, this.wsdlVisitor)) {
            this.visitForwardDeclaredObjectReference(this.getScope(), this.schemas, this.schema, node, scopedNames, this.wsdlVisitor);
        } else if (node.getType() == 53) {
            this.visitDefaultTypeObjectReference(node);
        } else {
            this.visitCustomTypeObjectReference(node);
        }
    }

    private void visitDefaultTypeObjectReference(AST node) {
        XmlSchema[] scs = this.schemas.getXmlSchema("http://www.w3.org/2005/08/addressing");
        XmlSchema wsaSchema = null;
        if (scs != null) {
            for (XmlSchema sc : scs) {
                if (!"http://www.w3.org/2005/08/addressing".equals(sc.getTargetNamespace())) continue;
                wsaSchema = sc;
                break;
            }
        }
        if (wsaSchema == null) {
            wsaSchema = new XmlSchema("http://www.w3.org/2005/08/addressing", this.schemas);
        }
        XmlSchemaType objectType = new XmlSchemaType(wsaSchema);
        objectType.setName("EndpointReferenceType");
        this.setSchemaType(objectType);
        org.apache.cxf.binding.corba.wsdl.Object corbaObject = new org.apache.cxf.binding.corba.wsdl.Object();
        corbaObject.setQName(new QName(this.typeMap.getTargetNamespace(), "CORBA.Object"));
        corbaObject.setRepositoryID("IDL:omg.org/CORBA/Object/1.0");
        corbaObject.setType(objectType.getQName());
        this.setCorbaType(corbaObject);
        if (!this.isReferenceCORBATypeDefined(corbaObject.getQName())) {
            this.typeMap.getStructOrExceptionOrUnion().add(corbaObject);
        }
    }

    private void visitCustomTypeObjectReference(AST node) {
        String tns;
        QName bindingName = null;
        QName referenceName = null;
        String repositoryID = null;
        Scope customScope = null;
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = this.getScope(); bindingName == null && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                customScope = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                if (this.mapper.isDefaultMapping()) {
                    referenceName = new QName(this.schema.getTargetNamespace(), customScope.toString() + "Ref");
                } else {
                    tns = this.mapper.map(customScope.getParent());
                    referenceName = new QName(tns, customScope.tail() + "Ref");
                }
                repositoryID = customScope.toIDLRepositoryID();
                bindingName = ObjectReferenceVisitor.getBindingQNameByID(this.definition, repositoryID, this.objRefWsdlVisitor);
            }
        }
        if (bindingName == null) {
            if (ScopedNameVisitor.isFullyScopedName(node)) {
                customScope = ScopedNameVisitor.getFullyScopedName(new Scope(), node);
                if (this.mapper.isDefaultMapping()) {
                    referenceName = new QName(this.schema.getTargetNamespace(), customScope.toString() + "Ref");
                } else {
                    tns = this.mapper.map(customScope.getParent());
                    referenceName = new QName(tns, customScope.tail() + "Ref");
                }
            } else {
                customScope = new Scope(new Scope(), node);
                if (this.mapper.isDefaultMapping()) {
                    referenceName = new QName(this.schema.getTargetNamespace(), customScope.toString() + "Ref");
                } else {
                    tns = this.mapper.map(customScope.getParent());
                    referenceName = new QName(tns, customScope.tail() + "Ref");
                }
            }
            repositoryID = customScope.toIDLRepositoryID();
            bindingName = ObjectReferenceVisitor.getBindingQNameByID(this.definition, repositoryID, this.objRefWsdlVisitor);
        }
        if (bindingName == null) {
            throw new RuntimeException("[ObjectReferenceVisitor: No binding available for endpoint]");
        }
        XmlSchema[] scs = this.schemas.getXmlSchema("http://www.w3.org/2005/08/addressing");
        XmlSchema wsaSchema = null;
        if (scs != null) {
            for (XmlSchema sc : scs) {
                if (!"http://www.w3.org/2005/08/addressing".equals(sc.getTargetNamespace())) continue;
                wsaSchema = sc;
                break;
            }
        }
        if (wsaSchema == null) {
            wsaSchema = new XmlSchema("http://www.w3.org/2005/08/addressing", this.schemas);
        }
        XmlSchemaType wsaType = new XmlSchemaType(wsaSchema);
        wsaType.setName("EndpointReferenceType");
        this.isDuplicateReference(referenceName, bindingName, customScope, wsaType, node);
        this.setSchemaType(wsaType);
        org.apache.cxf.binding.corba.wsdl.Object corbaObject = new org.apache.cxf.binding.corba.wsdl.Object();
        corbaObject.setBinding(bindingName);
        corbaObject.setQName(new QName(this.typeMap.getTargetNamespace(), customScope.toString()));
        corbaObject.setRepositoryID(repositoryID);
        corbaObject.setType(wsaType.getQName());
        this.setCorbaType(corbaObject);
        if (!this.isReferenceCORBATypeDefined(corbaObject.getQName())) {
            this.typeMap.getStructOrExceptionOrUnion().add(corbaObject);
        }
    }

    private void isDuplicateReference(QName referenceName, QName bindingName, Scope refScope, XmlSchemaType wsaType, AST node) {
        XmlSchema refSchema = null;
        if (!this.mapper.isDefaultMapping()) {
            String tns = this.mapper.map(refScope.getParent());
            String refSchemaFileName = this.getWsdlVisitor().getOutputDir() + System.getProperty("file.separator") + refScope.getParent().toString("_") + ".xsd";
            refSchema = this.manager.getXmlSchema(tns);
            if (refSchema == null) {
                refSchema = this.manager.createXmlSchema(tns, this.wsdlVisitor.getSchemas());
            }
            this.addWSAddressingImport(refSchema);
            this.manager.addXmlSchemaImport(this.schema, refSchema, refSchemaFileName);
        } else {
            refSchema = this.schema;
        }
        if (!this.isReferenceSchemaTypeDefined(referenceName, refSchema)) {
            XmlSchemaElement refElement = new XmlSchemaElement();
            refElement.setQName(referenceName);
            refElement.setName(referenceName.getLocalPart());
            refElement.setSchemaType(wsaType);
            refElement.setSchemaTypeName(wsaType.getQName());
            XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
            XmlSchemaAppInfo appInfo = new XmlSchemaAppInfo();
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.newDocument();
                Element el = doc.createElement("appinfo");
                el.setTextContent("corba:binding=" + bindingName.getLocalPart());
                appInfo.setMarkup(el.getChildNodes());
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException("[ObjectReferenceVisitor: error creating endpoint schema]");
            }
            annotation.getItems().add((XmlSchemaObject)appInfo);
            refElement.setAnnotation(annotation);
            refSchema.getElements().add(referenceName, (XmlSchemaObject)refElement);
            refSchema.getItems().add((XmlSchemaObject)refElement);
        }
    }

    private boolean isReferenceCORBATypeDefined(QName objectReferenceName) {
        List<CorbaTypeImpl> allTypes = this.typeMap.getStructOrExceptionOrUnion();
        for (CorbaTypeImpl impl : allTypes) {
            if (!impl.getQName().equals(objectReferenceName)) continue;
            return true;
        }
        return false;
    }

    private boolean isReferenceSchemaTypeDefined(QName objectReferenceName, XmlSchema refSchema) {
        XmlSchemaObjectCollection schemaObjects = refSchema.getItems();
        Iterator iter = schemaObjects.getIterator();
        while (iter.hasNext()) {
            XmlSchemaElement el;
            Object schemaObj = iter.next();
            if (!(schemaObj instanceof XmlSchemaElement) || !(el = (XmlSchemaElement)schemaObj).getName().equals(objectReferenceName.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    private void addWSAddressingImport(XmlSchema s) {
        boolean alreadyImported = false;
        Iterator i = s.getIncludes().getIterator();
        while (i.hasNext()) {
            XmlSchemaImport schemaImport;
            Object o = i.next();
            if (!(o instanceof XmlSchemaImport) || !(schemaImport = (XmlSchemaImport)o).getNamespace().equals("http://www.w3.org/2005/08/addressing")) continue;
            alreadyImported = true;
            break;
        }
        if (!alreadyImported) {
            XmlSchemaImport wsaImport = new XmlSchemaImport();
            wsaImport.setNamespace("http://www.w3.org/2005/08/addressing");
            wsaImport.setSchemaLocation("http://www.w3.org/2005/08/addressing/ws-addr.xsd");
            s.getItems().add((XmlSchemaObject)wsaImport);
            s.getIncludes().add((XmlSchemaObject)wsaImport);
        }
        this.definition.addNamespace("wsa", "http://www.w3.org/2005/08/addressing");
        try {
            NamespaceMap nsMap = (NamespaceMap)s.getNamespaceContext();
            if (nsMap == null) {
                nsMap = new NamespaceMap();
                nsMap.add("wsa", "http://www.w3.org/2005/08/addressing");
                s.setNamespaceContext((NamespacePrefixList)nsMap);
            } else {
                nsMap.add("wsa", "http://www.w3.org/2005/08/addressing");
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static QName getBindingQNameByID(Definition wsdlDef, String repositoryID, WSDLASTVisitor wsdlVisitor) {
        Collection bindings = wsdlDef.getBindings().values();
        if (bindings.isEmpty() && !wsdlVisitor.getModuleToNSMapper().isDefaultMapping()) {
            bindings = wsdlVisitor.getDefinition().getBindings().values();
        }
        for (Binding b : bindings) {
            List extElements = b.getExtensibilityElements();
            for (Object element : extElements) {
                BindingType bt;
                if (!(element instanceof BindingType) || !(bt = (BindingType)element).getRepositoryID().equals(repositoryID)) continue;
                if (wsdlVisitor.getSupportPolymorphicFactories()) {
                    return new QName(b.getQName().getNamespaceURI(), "InferFromTypeId", b.getQName().getPrefix());
                }
                return b.getQName();
            }
        }
        return null;
    }

    protected static boolean isForwardDeclaredReference(Scope scope, XmlSchema schema, AST node, ScopeNameCollection scopedNames, WSDLASTVisitor wsdlVisitor) {
        Scope scopedName;
        boolean isForward = false;
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = scope; !isForward && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                scopedName = null;
                scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                if (scopedNames.getScope(scopedName) == null) continue;
                isForward = true;
            }
        }
        if (!isForward) {
            scopedName = null;
            scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(new Scope(), node) : new Scope(new Scope(), node);
            if (scopedNames.getScope(scopedName) != null) {
                isForward = true;
            }
        }
        return isForward;
    }

    protected void visitForwardDeclaredObjectReference(Scope scope, XmlSchemaCollection schemas, XmlSchema schema, AST node, ScopeNameCollection scopedNames, WSDLASTVisitor wsdlVisitor) {
        XmlSchemaType wsaType;
        XmlSchema wsaSchema;
        Scope scopedName;
        XmlSchemaType result = null;
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = scope; result == null && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                scopedName = null;
                scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                if (scopedNames.getScope(scopedName) == null) continue;
                wsaSchema = new XmlSchema("http://www.w3.org/2005/08/addressing", schemas);
                wsaType = new XmlSchemaType(wsaSchema);
                wsaType.setName("EndpointReferenceType");
                result = wsaType;
            }
        }
        if (result == null) {
            scopedName = null;
            scopedName = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(new Scope(), node) : scope;
            if (scopedNames.getScope(scopedName) != null) {
                wsaSchema = new XmlSchema("http://www.w3.org/2005/08/addressing", schemas);
                wsaType = new XmlSchemaType(wsaSchema);
                wsaType.setName("EndpointReferenceType");
                result = wsaType;
            }
        }
        this.setSchemaType(result);
    }

    private static boolean hasBinding(Scope scope, XmlSchema s, Definition def, AST node, WSDLASTVisitor wsdlVisitor) {
        boolean result = false;
        QName bindingName = null;
        String repositoryID = null;
        Scope customScope = null;
        if (node.getFirstChild() == null || node.getFirstChild() != null && node.getFirstChild().getType() != 16) {
            for (Scope currentScope = scope; bindingName == null && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                customScope = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(currentScope, node) : new Scope(currentScope, node);
                repositoryID = customScope.toIDLRepositoryID();
                bindingName = ObjectReferenceVisitor.getBindingQNameByID(def, repositoryID, wsdlVisitor);
            }
        }
        if (bindingName == null) {
            customScope = ScopedNameVisitor.isFullyScopedName(node) ? ScopedNameVisitor.getFullyScopedName(new Scope(), node) : new Scope(new Scope(), node);
            repositoryID = customScope.toIDLRepositoryID();
            bindingName = ObjectReferenceVisitor.getBindingQNameByID(def, repositoryID, wsdlVisitor);
        }
        if (bindingName != null) {
            result = true;
        }
        return result;
    }
}

