/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.extensions.ExtensionDeserializer;
import org.w3c.dom.Node;

class FixedExtensionDeserializer
implements ExtensionDeserializer {
    FixedExtensionDeserializer() {
    }

    public void deserialize(XmlSchemaObject schemaObject, QName name, Node node) {
        HashMap metaInfoMap = schemaObject.getMetaInfoMap();
        if (metaInfoMap == null) {
            metaInfoMap = new HashMap();
        }
        if (node.getNodeType() == 2) {
            Map<QName, Node> attribMap;
            if (name.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                return;
            }
            if (metaInfoMap.containsKey("EXTERNAL_ATTRIBUTES")) {
                attribMap = (Map)metaInfoMap.get("EXTERNAL_ATTRIBUTES");
            } else {
                attribMap = new HashMap();
                metaInfoMap.put("EXTERNAL_ATTRIBUTES", attribMap);
            }
            attribMap.put(name, node);
        } else if (node.getNodeType() == 1) {
            Map<QName, Node> elementMap;
            if (metaInfoMap.containsKey("EXTERNAL_ELEMENTS")) {
                elementMap = (Map)metaInfoMap.get("EXTERNAL_ELEMENTS");
            } else {
                elementMap = new HashMap();
                metaInfoMap.put("EXTERNAL_ELEMENTS", elementMap);
            }
            elementMap.put(name, node);
        }
        if (!metaInfoMap.isEmpty() && schemaObject.getMetaInfoMap() == null) {
            schemaObject.setMetaInfoMap(metaInfoMap);
        }
    }
}

