/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointPolicyImpl
implements EndpointPolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EndpointPolicyImpl.class);
    private Policy policy;
    private Collection<Assertion> chosenAlternative;
    private Collection<Assertion> vocabulary;
    private Collection<Assertion> faultVocabulary;
    private List<Interceptor> interceptors;
    private List<Interceptor> faultInterceptors;
    private EndpointInfo ei;
    private PolicyEngineImpl engine;
    private boolean requestor;
    private Assertor assertor;

    public EndpointPolicyImpl() {
    }

    public EndpointPolicyImpl(EndpointInfo ei, PolicyEngineImpl engine, boolean requestor, Assertor assertor) {
        this.ei = ei;
        this.engine = engine;
        this.requestor = requestor;
        this.assertor = assertor;
    }

    @Override
    public Policy getPolicy() {
        return this.policy;
    }

    @Override
    public EndpointPolicy updatePolicy(Policy p) {
        EndpointPolicyImpl epi = this.createEndpointPolicy();
        Policy np = (Policy)p.normalize(true);
        epi.setPolicy(this.getPolicy().merge(np));
        epi.checkExactlyOnes();
        epi.finalizeConfig();
        return epi;
    }

    @Override
    public Collection<Assertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    @Override
    public Collection<Assertion> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public Collection<Assertion> getFaultVocabulary() {
        return this.faultVocabulary;
    }

    @Override
    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public List<Interceptor> getFaultInterceptors() {
        return this.faultInterceptors;
    }

    void initialize() {
        this.initializePolicy();
        this.checkExactlyOnes();
        this.finalizeConfig();
    }

    void finalizeConfig() {
        this.chooseAlternative();
        this.initializeVocabulary();
        this.initializeInterceptors();
    }

    void initializePolicy() {
        this.policy = this.engine.getAggregatedServicePolicy(this.ei.getService());
        this.policy = this.policy.merge(this.engine.getAggregatedEndpointPolicy(this.ei));
        if (!this.policy.isEmpty()) {
            this.policy = (Policy)this.policy.normalize(true);
        }
    }

    void chooseAlternative() {
        Collection<Assertion> alternative = this.engine.getAlternativeSelector().selectAlternative(this.policy, this.engine, this.assertor);
        if (null == alternative) {
            throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    void initializeVocabulary() {
        this.vocabulary = new ArrayList<Assertion>();
        if (this.requestor) {
            this.faultVocabulary = new ArrayList<Assertion>();
        }
        for (Assertion a : this.getChosenAlternative()) {
            if (a.isOptional()) continue;
            this.vocabulary.add(a);
            if (null == this.faultVocabulary) continue;
            this.faultVocabulary.add(a);
        }
        for (BindingOperationInfo boi : this.ei.getBinding().getOperations()) {
            Policy p = this.engine.getAggregatedOperationPolicy(boi);
            Collection<Assertion> c = this.engine.getAssertions((PolicyComponent)p, false);
            this.vocabulary.addAll(c);
            if (null != this.faultVocabulary) {
                this.faultVocabulary.addAll(c);
            }
            if (!this.requestor) {
                p = this.engine.getAggregatedMessagePolicy(boi.getInput());
                this.vocabulary.addAll(this.engine.getAssertions((PolicyComponent)p, false));
                continue;
            }
            if (null == boi.getOutput()) continue;
            p = this.engine.getAggregatedMessagePolicy(boi.getOutput());
            this.vocabulary.addAll(this.engine.getAssertions((PolicyComponent)p, false));
            for (BindingFaultInfo bfi : boi.getFaults()) {
                p = this.engine.getAggregatedFaultPolicy(bfi);
                this.faultVocabulary.addAll(this.engine.getAssertions((PolicyComponent)p, false));
            }
        }
    }

    void initializeInterceptors() {
        PolicyInterceptorProviderRegistry reg = this.engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        this.interceptors = new ArrayList<Interceptor>();
        if (this.requestor) {
            this.faultInterceptors = new ArrayList<Interceptor>();
        }
        HashSet<QName> v = new HashSet<QName>();
        for (Assertion a : this.vocabulary) {
            v.add(a.getName());
        }
        for (QName qn : v) {
            PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get(qn);
            if (null == pp) continue;
            this.interceptors.addAll(pp.getInInterceptors());
        }
        if (!this.requestor) {
            return;
        }
        HashSet<QName> faultV = new HashSet<QName>();
        for (Assertion a : this.faultVocabulary) {
            faultV.add(a.getName());
        }
        for (QName qn : faultV) {
            PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get(qn);
            if (null == pp) continue;
            this.faultInterceptors.addAll(pp.getInFaultInterceptors());
        }
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<Assertion> c) {
        this.chosenAlternative = c;
    }

    void setVocabulary(Collection<Assertion> v) {
        this.vocabulary = v;
    }

    void setFaultVocabulary(Collection<Assertion> v) {
        this.faultVocabulary = v;
    }

    void setInterceptors(List<Interceptor> in) {
        this.interceptors = in;
    }

    void setFaultInterceptors(List<Interceptor> inFault) {
        this.faultInterceptors = inFault;
    }

    protected EndpointPolicyImpl createEndpointPolicy() {
        return new EndpointPolicyImpl(this.ei, this.engine, this.requestor, this.assertor);
    }

    void checkExactlyOnes() {
        List assertions = this.policy.getPolicyComponents();
        if (assertions.size() <= 1) {
            return;
        }
        Policy p = new Policy();
        ExactlyOne alternatives = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)alternatives);
        for (Object a : assertions) {
            alternatives.addPolicyComponents(((ExactlyOne)a).getPolicyComponents());
        }
        this.setPolicy(p);
    }
}

