/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionInfoMap
extends HashMap<QName, Collection<AssertionInfo>> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AssertionInfoMap.class, (String)"APIMessages");

    public AssertionInfoMap(Policy p) {
        this(AssertionInfoMap.getAssertions((PolicyOperator)p));
    }

    public AssertionInfoMap(Collection<PolicyAssertion> assertions) {
        super(assertions.size());
        for (PolicyAssertion a : assertions) {
            this.putAssertionInfo(a);
        }
    }

    private void putAssertionInfo(PolicyAssertion a) {
        Policy p = a.getPolicy();
        if (p != null) {
            for (PolicyAssertion na : AssertionInfoMap.getAssertions((PolicyOperator)p)) {
                this.putAssertionInfo(na);
            }
        }
        AssertionInfo ai = new AssertionInfo(a);
        ArrayList<AssertionInfo> ail = (ArrayList<AssertionInfo>)this.get(a.getName());
        if (ail == null) {
            ail = new ArrayList<AssertionInfo>();
            this.put(a.getName(), ail);
        }
        ail.add(ai);
    }

    public Collection<AssertionInfo> getAssertionInfo(QName name) {
        Collection ail = (Collection)this.get(name);
        return ail != null ? ail : CastUtils.cast((List)Collections.EMPTY_LIST, AssertionInfo.class);
    }

    public boolean supportsAlternative(Collection<PolicyAssertion> alternative) {
        for (PolicyAssertion a : alternative) {
            if (a.isAsserted(this)) continue;
            return false;
        }
        return true;
    }

    public void checkEffectivePolicy(Policy policy) {
        Iterator alternatives = policy.getAlternatives();
        while (alternatives.hasNext()) {
            List alternative = CastUtils.cast((List)((List)alternatives.next()), PolicyAssertion.class);
            if (!this.supportsAlternative(alternative)) continue;
            return;
        }
        throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
    }

    public void check() {
        for (Collection ais : this.values()) {
            for (AssertionInfo ai : ais) {
                if (ai.isAsserted()) continue;
                throw new PolicyException(new Message("NOT_ASSERTED_EXC", BUNDLE, new Object[]{ai.getAssertion().getName()}));
            }
        }
    }

    private static Collection<PolicyAssertion> getAssertions(PolicyOperator p) {
        List pcs = CastUtils.cast((List)p.getPolicyComponents(), PolicyComponent.class);
        if (pcs.size() == 0 || pcs.get(0) instanceof PolicyAssertion) {
            return CastUtils.cast((List)pcs, PolicyAssertion.class);
        }
        ArrayList<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>();
        for (PolicyComponent pc : pcs) {
            assertions.addAll(AssertionInfoMap.getAssertions((PolicyOperator)pc));
        }
        return assertions;
    }
}

