/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.jarloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.cxf.helpers.CastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JarLoader {
    static Map<String, Object> archives = new HashMap<String, Object>();
    static final int CHUNK_SIZE = 4096;
    static final int MAX_CHUNK_SIZE = 65536;

    private JarLoader() {
    }

    public static byte[] getBytesFromInputStream(InputStream is) throws IOException {
        return JarLoader.getBytesFromInputStream(is, -1L);
    }

    public static synchronized Map getJarContents(String path) throws MalformedURLException, IOException {
        if (!archives.containsKey(path)) {
            JarLoader.loadArchive(path);
        }
        return (Map)archives.get(path);
    }

    private static void loadArchive(String path) throws MalformedURLException, IOException {
        List<String> nameComponents = JarLoader.tokenizePathComponents(path);
        for (int i = 0; i < nameComponents.size(); ++i) {
            if (archives.containsKey(JarLoader.buildPartialName(nameComponents, i + 1))) continue;
            JarLoader.readArchive(JarLoader.buildPartialName(nameComponents, i + 1));
            if (i == 0) continue;
            Map parentMap = CastUtils.cast((Map)((Map)archives.get(JarLoader.buildPartialName(nameComponents, i))));
            Map archiveMap = (Map)archives.get(JarLoader.buildPartialName(nameComponents, i + 1));
            parentMap.put(nameComponents.get(i), archiveMap);
        }
    }

    private static List<String> tokenizePathComponents(String path) {
        LinkedList<String> tokens = new LinkedList<String>();
        String tmpPath = new String(path);
        while (tmpPath.length() > 0) {
            if (tmpPath.indexOf("!/") == -1) {
                tokens.add(tmpPath);
                tmpPath = "";
                continue;
            }
            tokens.add(tmpPath.substring(0, tmpPath.indexOf("!/")));
            tmpPath = tmpPath.substring(tmpPath.indexOf("!/") + 2);
        }
        return tokens;
    }

    private static String buildPartialName(List<String> nameComponents, int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(nameComponents.get(i));
            sb.append("!/");
        }
        return sb.toString();
    }

    private static String getRootArchiveName(String name) {
        int index = name.indexOf("file:");
        if (index > -1) {
            name = name.substring(index);
        }
        if (name.indexOf("!/") != -1) {
            return name.substring(0, name.indexOf("!/"));
        }
        return name;
    }

    private static void readArchive(String name) throws MalformedURLException, IOException {
        List<String> nameComponents = JarLoader.tokenizePathComponents(name);
        Map<String, Object> map = null;
        if (nameComponents.size() == 1) {
            map = JarLoader.readZipStream(new URL(JarLoader.getRootArchiveName(name)).openStream());
        } else {
            Map parentMap = (Map)archives.get(JarLoader.buildPartialName(nameComponents, nameComponents.size() - 1));
            byte[] bytes = (byte[])parentMap.get(nameComponents.get(nameComponents.size() - 1));
            if (null == bytes) {
                throw new IOException("Enclosing archive " + JarLoader.buildPartialName(nameComponents, nameComponents.size() - 1) + " has no entry named:" + nameComponents.get(nameComponents.size() - 1) + ", error in archive classpath");
            }
            map = JarLoader.readZipStream(new ByteArrayInputStream(bytes));
        }
        archives.put(name, map);
    }

    private static Map<String, Object> readZipStream(InputStream is) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            if (ze.isDirectory()) {
                map.put(ze.getName(), ze.getName());
            } else {
                byte[] bytes = JarLoader.getBytesFromInputStream(zis, ze.getSize());
                map.put(ze.getName(), bytes);
            }
            ze = zis.getNextEntry();
        }
        return map;
    }

    private static byte[] getBytesFromInputStream(InputStream is, long size) throws IOException {
        byte[] chunk = new byte[size > 4096L && size < 65536L ? (int)size : 4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = is.read(chunk, 0, chunk.length);
        while (i != -1) {
            baos.write(chunk, 0, i);
            i = is.read(chunk, 0, chunk.length);
        }
        return baos.toByteArray();
    }
}

