/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.spnego;

import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpnegoServiceAction
implements PrivilegedAction<byte[]> {
    private static Log log = LogFactory.getLog(SpnegoServiceAction.class);
    private byte[] ticket;
    private String serviceName;
    private GSSContext secContext;

    public SpnegoServiceAction(byte[] ticket, String serviceName) {
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    @Override
    public byte[] run() {
        try {
            if (this.secContext == null) {
                GSSManager gssManager = GSSManager.getInstance();
                Oid oid = new Oid("1.3.6.1.5.5.2");
                GSSName gssService = gssManager.createName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE);
                this.secContext = gssManager.createContext(gssService, oid, null, 0);
            }
            return this.secContext.acceptSecContext(this.ticket, 0, this.ticket.length);
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error in obtaining a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }

    public GSSContext getContext() {
        return this.secContext;
    }
}

