/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509Security
extends BinarySecurity {
    public static final String X509_V3_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public static final String X509_V1_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1";
    private X509Certificate cachedCert = null;

    public X509Security(Element elem) throws WSSecurityException {
        super(elem);
        String valueType = this.getValueType();
        if (!valueType.equals(X509_V3_TYPE) && !valueType.equals(X509_V1_TYPE)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{this.getValueType()});
        }
    }

    public X509Security(Document doc) {
        super(doc);
    }

    public X509Certificate getX509Certificate(Crypto crypto) throws WSSecurityException {
        if (this.cachedCert != null) {
            return this.cachedCert;
        }
        byte[] data = this.getToken();
        if (data == null) {
            throw new WSSecurityException(0, "invalidCertData", new Object[]{new Integer(0)});
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        this.cachedCert = crypto.loadCertificate(in);
        return this.cachedCert;
    }

    public void setX509Certificate(X509Certificate cert) throws WSSecurityException {
        if (cert == null) {
            throw new WSSecurityException(0, "noCert");
        }
        if (cert.getVersion() == 1) {
            this.setValueType(X509_V1_TYPE);
        } else {
            this.setValueType(X509_V3_TYPE);
        }
        this.cachedCert = cert;
        try {
            this.setToken(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
    }
}

