/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ant.extensions;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.ant.extensions.CxfAntTask;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class WSDL2JavaTask
extends CxfAntTask {
    private String wsdlLocation;
    private String wsdl;
    private Set<File> bindingFiles = new HashSet<File>();

    public void setWsdlLocation(String w) {
        this.wsdlLocation = w;
    }

    public void setWsdl(String w) {
        this.wsdl = w;
    }

    public void addConfiguredBinding(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (int i = 0; i < includedFiles.length; ++i) {
            this.bindingFiles.add(new File(baseDir, includedFiles[i]));
        }
    }

    public void execute() throws BuildException {
        this.buildCommandLine();
        LogStreamHandler log = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)log);
        exe.setAntRun(this.getProject());
        exe.setCommandline(this.cmd.getCommandline());
        try {
            int rc = exe.execute();
            if (exe.killedProcess() || rc != 0) {
                throw new BuildException("wsdl2java failed", this.getLocation());
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private void buildCommandLine() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Path classpath = new Path(this.getProject());
        if (loader instanceof AntClassLoader) {
            classpath = new Path(this.getProject(), ((AntClassLoader)loader).getClasspath());
        }
        this.cmd.createClasspath(this.getProject()).append(classpath);
        this.cmd.createVmArgument().setLine("-Djava.util.logging.config.file=");
        this.cmd.setClassname(WSDLToJava.class.getName());
        if (null != this.classesDir && !StringUtils.isEmpty((String)this.classesDir.getName())) {
            this.cmd.createArgument().setValue("-classdir");
            this.cmd.createArgument().setFile(this.classesDir);
            this.cmd.createArgument().setValue("-compile");
        }
        if (null != this.sourcesDir && !StringUtils.isEmpty((String)this.sourcesDir.getName())) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.sourcesDir);
        }
        if (this.verbose) {
            this.cmd.createArgument().setValue("-verbose");
        }
        if (!this.bindingFiles.isEmpty()) {
            for (File b : this.bindingFiles) {
                this.cmd.createArgument().setValue("-b");
                this.cmd.createArgument().setFile(b);
            }
        }
        if (!StringUtils.isEmpty((String)this.wsdlLocation)) {
            this.cmd.createArgument().setValue("-wsdlLocation");
            this.cmd.createArgument().setValue(this.wsdlLocation);
        }
        if (!StringUtils.isEmpty((String)this.wsdl)) {
            this.cmd.createArgument().setValue(this.wsdl);
        }
    }
}

