/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.lang.reflect.Modifier;
import java.util.ResourceBundle;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.interceptor.Fault;

public class LocalFactory
implements Factory {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(LocalFactory.class);
    private final Class svcClass;

    public LocalFactory(Class svcClass) {
        this.svcClass = svcClass;
    }

    public Object create() throws Fault {
        try {
            if (this.svcClass.isInterface()) {
                throw new Fault(new Message("SVC_CLASS_IS_INTERFACE", BUNDLE, new Object[]{this.svcClass.getName()}));
            }
            if (Modifier.isAbstract(this.svcClass.getModifiers())) {
                throw new Fault(new Message("SVC_CLASS_IS_ABSTRACT", BUNDLE, new Object[]{this.svcClass.getName()}));
            }
            return this.svcClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new Fault(new Message("COULD_NOT_INSTANTIATE", BUNDLE, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw new Fault(new Message("ILLEGAL_ACCESS", BUNDLE, new Object[0]));
        }
    }
}

