/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.util.ResourceBundle;
import org.apache.cxf.attachment.AttachmentSerializer;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String WRITE_ATTACHMENTS = "write.attachments";
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AttachmentOutInterceptor.class);
    private AttachmentOutEndingInterceptor ending = new AttachmentOutEndingInterceptor();

    public AttachmentOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        boolean mtomEnabled = MessageUtils.isTrue((Object)message.getContextualProperty("mtom-enabled"));
        boolean writeAtts = MessageUtils.isTrue((Object)message.getContextualProperty(WRITE_ATTACHMENTS));
        if (!mtomEnabled && !writeAtts) {
            return;
        }
        AttachmentSerializer serializer = new AttachmentSerializer(message);
        serializer.setXop(mtomEnabled);
        try {
            serializer.writeProlog();
        }
        catch (IOException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("WRITE_ATTACHMENTS", BUNDLE, new Object[0]), (Throwable)e);
        }
        message.setContent(AttachmentSerializer.class, (Object)serializer);
        message.getInterceptorChain().add((Interceptor)this.ending);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttachmentOutEndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public AttachmentOutEndingInterceptor() {
            super("pre-stream-ending");
        }

        public void handleMessage(Message message) {
            AttachmentSerializer ser = (AttachmentSerializer)message.getContent(AttachmentSerializer.class);
            if (ser != null) {
                try {
                    ser.writeAttachments();
                }
                catch (IOException e) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("WRITE_ATTACHMENTS", BUNDLE, new Object[0]), (Throwable)e);
                }
            }
        }
    }
}

