/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionType
extends ArrayType {
    private Type componentType;

    public CollectionType(Type componentType) {
        this.componentType = componentType;
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        try {
            return this.readCollection(reader, context);
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", e);
        }
    }

    @Override
    protected Collection<Object> createCollection() {
        Collection<Object> values = null;
        if (this.getTypeClass().isAssignableFrom(List.class)) {
            values = new ArrayList<Object>();
        } else if (this.getTypeClass().isAssignableFrom(Set.class)) {
            values = new HashSet();
        } else if (this.getTypeClass().isAssignableFrom(Vector.class)) {
            values = new Vector();
        } else if (this.getTypeClass().isInterface()) {
            values = new ArrayList();
        } else {
            try {
                values = (Collection)this.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new DatabindingException("Could not create map implementation: " + this.getTypeClass().getName(), e);
            }
        }
        return values;
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        if (object == null) {
            return;
        }
        try {
            Collection list = (Collection)object;
            Type type = this.getComponentType();
            if (type == null) {
                throw new DatabindingException("Couldn't find component type for Collection.");
            }
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                String ns = null;
                ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                this.writeValue(itr.next(), writer, context, type, type.getSchemaType().getLocalPart(), ns);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", e);
        }
    }

    @Override
    public Type getComponentType() {
        return this.componentType;
    }
}

