/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.common.classloader.FireWallClassLoader;
import org.apache.cxf.common.logging.LogUtils;

public class ComponentClassLoader
extends URLClassLoader {
    private static final Logger LOG = LogUtils.getL7dLogger(ComponentClassLoader.class);
    private static final String FILTERS_PROPS_FILE = "filters.properties";
    private static final String NEFILTERS_PROPS_FILE = "negativefilters.properties";

    public ComponentClassLoader(URL[] urls, ClassLoader p) throws IOException {
        super(urls, (ClassLoader)new FireWallClassLoader(p, ComponentClassLoader.getFilterList(p, FILTERS_PROPS_FILE), ComponentClassLoader.getFilterList(p, NEFILTERS_PROPS_FILE)));
    }

    public void addResource(URL url) {
        this.addURL(url);
    }

    private static String[] getFilterList(ClassLoader parent, String propFile) throws IOException {
        Properties filtersProps = ComponentClassLoader.getProperties(parent, propFile);
        Iterator<Object> i = filtersProps.keySet().iterator();
        while (i.hasNext()) {
            LOG.config("get Filter " + propFile + "::" + (String)i.next());
        }
        return filtersProps.keySet().toArray(new String[0]);
    }

    private static Properties getProperties(ClassLoader parent, String propsFileName) throws IOException {
        InputStream in = parent.getResourceAsStream(propsFileName);
        if (null == in && null == (in = ComponentClassLoader.class.getResourceAsStream(propsFileName))) {
            String msg = "Internal component classloader failed to locate configuration resource: " + propsFileName;
            IOException ioe = new IOException(msg);
            LOG.warning(ioe.toString());
            throw ioe;
        }
        Properties props = new Properties();
        props.load(in);
        LOG.fine("Contents: " + propsFileName + props);
        return props;
    }
}

