/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.test;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.junit.Assert;

public class TestUtil {
    static String unexpectedParamValueMsg = "unexpected parameter value for descriptor file %1$s for param: %2$s";

    public static JCas processAE(AnalysisEngine ae, File textFile) throws ResourceInitializationException {
        return TestUtil.processAE(ae, textFile, "UTF-8");
    }

    public static JCas processAE(AnalysisEngine ae, File textFile, String charSetName) throws ResourceInitializationException {
        try {
            String text = FileUtils.file2String((File)textFile, (String)charSetName);
            return TestUtil.processAE(ae, text);
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
    }

    public static JCas processAE(AnalysisEngine ae, String text) throws ResourceInitializationException {
        try {
            JCas jCas = ae.newJCas();
            jCas.setDocumentText(text);
            ae.process(jCas);
            return jCas;
        }
        catch (AnalysisEngineProcessException aepe) {
            throw new ResourceInitializationException((Throwable)aepe);
        }
    }

    public static AnalysisEngine getAE(File analysisEngineDescriptorFile) throws ResourceInitializationException {
        try {
            XMLInputSource xmlInputSource = new XMLInputSource(analysisEngineDescriptorFile);
            XMLParser xmlParser = UIMAFramework.getXMLParser();
            ResourceSpecifier resourceSpecifier = xmlParser.parseResourceSpecifier(xmlInputSource);
            AnalysisEngine analysisEngine = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)resourceSpecifier);
            return analysisEngine;
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
        catch (InvalidXMLException ixe) {
            throw new ResourceInitializationException((Throwable)ixe);
        }
    }

    public static CollectionReader getCR(File collectionReaderDescriptorFile) throws ResourceInitializationException {
        try {
            XMLInputSource xmlInputSource = new XMLInputSource(collectionReaderDescriptorFile);
            XMLParser xmlParser = UIMAFramework.getXMLParser();
            ResourceSpecifier resourceSpecifier = xmlParser.parseResourceSpecifier(xmlInputSource);
            CollectionReader collectionReader = UIMAFramework.produceCollectionReader((ResourceSpecifier)resourceSpecifier);
            return collectionReader;
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
        catch (InvalidXMLException ixe) {
            throw new ResourceInitializationException((Throwable)ixe);
        }
    }

    public static <T extends TOP> int getFeatureStructureSize(JCas jCas, Class<T> cls) {
        try {
            int type = (Integer)cls.getField("type").get(null);
            AnnotationIndex fsIndex = jCas.getAnnotationIndex(type);
            FSIterator iterator = fsIndex.iterator();
            int size = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            return size;
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("class passed in caused an exception: class=" + cls.getCanonicalName(), iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException("class passed in caused an exception: class=" + cls.getCanonicalName(), nsfe);
        }
    }

    public static <T extends TOP> T getFeatureStructureAtIndex(JCas jCas, Class<T> cls, int index) {
        try {
            int type = (Integer)cls.getField("type").get(null);
            AnnotationIndex fsIndex = jCas.getAnnotationIndex(type);
            if (index < 0) {
                throw new IllegalArgumentException("index less than zero: index=" + index);
            }
            if (index >= fsIndex.size()) {
                throw new IllegalArgumentException("index greater than or equal to fsIndex.size(): index=" + index);
            }
            FSIterator iterator = fsIndex.iterator();
            Object obj = null;
            for (int i = 0; i <= index; ++i) {
                obj = iterator.next();
            }
            return (T)((TOP)cls.cast(obj));
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("class passed in caused an exception: class=" + cls.getCanonicalName(), iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException("class passed in caused an exception: class=" + cls.getCanonicalName(), nsfe);
        }
    }

    public static void testConfigParam(UimaContext uimaContext, String descriptorFile, String paramName, Object paramValue) {
        TestUtil.testConfigParam(uimaContext, descriptorFile, paramName, paramValue, null);
    }

    public static void testConfigParam(UimaContext uimaContext, String descriptorFile, String paramName, Object paramValue, Integer arrayIndex) {
        if (arrayIndex == null) {
            Assert.assertEquals((String)String.format(unexpectedParamValueMsg, descriptorFile, paramName), (Object)paramValue, (Object)uimaContext.getConfigParameterValue(paramName));
        } else {
            Assert.assertEquals((String)String.format(unexpectedParamValueMsg, descriptorFile, paramName), (Object)paramValue, (Object)((Object[])uimaContext.getConfigParameterValue(paramName))[arrayIndex]);
        }
    }
}

