/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.URLFileNameParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;

public class UrlFileNameParser
extends AbstractFileNameParser {
    private final URLFileNameParser url = new URLFileNameParser(80);
    private final GenericFileNameParser generic = new GenericFileNameParser();

    @Override
    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '?';
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        if (this.isUrlBased(base, uri)) {
            return this.url.parseUri(context, base, uri);
        }
        return this.generic.parseUri(context, base, uri);
    }

    protected boolean isUrlBased(FileName base, String fileName) {
        if (base instanceof URLFileName) {
            return true;
        }
        return this.countSlashes(fileName) == 2;
    }

    protected int countSlashes(String fileName) {
        int state = 0;
        int nuofSlash = 0;
        for (int pos = 0; pos < fileName.length(); ++pos) {
            char c = fileName.charAt(pos);
            if (state == 0) {
                if (c >= 'a' && c <= 'z' || c != ':') continue;
                ++state;
                continue;
            }
            if (state != true) continue;
            if (c != '/') {
                return nuofSlash;
            }
            ++nuofSlash;
        }
        return nuofSlash;
    }
}

