/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4s;

import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http4s.Http4sFileProvider;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileProvider;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystem;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav4s.Webdav4sFileNameParser;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;

public class Webdav4sFileProvider
extends Http4sFileProvider {
    protected static final Collection<Capability> capabilities = Webdav4FileProvider.DEFAULT_CAPABILITIES;

    public Webdav4sFileProvider() {
        this.setFileNameParser(Webdav4sFileNameParser.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        FileSystemOptions fsOpts = fileSystemOptions == null ? new FileSystemOptions() : fileSystemOptions;
        UserAuthenticationData authData = null;
        HttpClient httpClient = null;
        HttpClientContext httpClientContext = null;
        try {
            Webdav4FileSystemConfigBuilder builder = Webdav4FileSystemConfigBuilder.getInstance();
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fsOpts, (UserAuthenticationData.Type[])Webdav4FileProvider.AUTHENTICATOR_TYPES);
            httpClientContext = this.createHttpClientContext(builder, rootName, fsOpts, authData);
            httpClient = this.createHttpClient(builder, rootName, fsOpts);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        return new Webdav4FileSystem((FileName)rootName, fsOpts, httpClient, httpClientContext){};
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return Webdav4FileSystemConfigBuilder.getInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

