/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public final class GeometricSampler {
    private GeometricSampler() {
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double probabilityOfSuccess) {
        if (probabilityOfSuccess <= 0.0 || probabilityOfSuccess > 1.0) {
            throw new IllegalArgumentException("Probability of success (p) must be in the range [0 < p <= 1]: " + probabilityOfSuccess);
        }
        return probabilityOfSuccess == 1.0 ? GeometricP1Sampler.INSTANCE : new GeometricExponentialSampler(rng, probabilityOfSuccess);
    }

    private static class GeometricExponentialSampler
    implements SharedStateDiscreteSampler {
        private final UniformRandomProvider rng;
        private final SharedStateContinuousSampler exponentialSampler;

        GeometricExponentialSampler(UniformRandomProvider rng, double probabilityOfSuccess) {
            this.rng = rng;
            double exponentialMean = 1.0 / -Math.log1p(-probabilityOfSuccess);
            this.exponentialSampler = AhrensDieterExponentialSampler.of(rng, exponentialMean);
        }

        GeometricExponentialSampler(UniformRandomProvider rng, GeometricExponentialSampler source) {
            this.rng = rng;
            this.exponentialSampler = (SharedStateContinuousSampler)source.exponentialSampler.withUniformRandomProvider(rng);
        }

        @Override
        public int sample() {
            return (int)Math.floor(this.exponentialSampler.sample());
        }

        public String toString() {
            return "Geometric deviate [" + this.rng.toString() + "]";
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new GeometricExponentialSampler(rng, this);
        }
    }

    private static class GeometricP1Sampler
    implements SharedStateDiscreteSampler {
        static final GeometricP1Sampler INSTANCE = new GeometricP1Sampler();

        private GeometricP1Sampler() {
        }

        @Override
        public int sample() {
            return 0;
        }

        public String toString() {
            return "Geometric(p=1) deviate";
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return this;
        }
    }
}

