/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class GaussianSampler
implements SharedStateContinuousSampler {
    private final double mean;
    private final double standardDeviation;
    private final NormalizedGaussianSampler normalized;

    public GaussianSampler(NormalizedGaussianSampler normalized, double mean, double standardDeviation) {
        if (standardDeviation <= 0.0) {
            throw new IllegalArgumentException("standard deviation is not strictly positive: " + standardDeviation);
        }
        this.normalized = normalized;
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    private GaussianSampler(UniformRandomProvider rng, GaussianSampler source) {
        this.mean = source.mean;
        this.standardDeviation = source.standardDeviation;
        this.normalized = InternalUtils.newNormalizedGaussianSampler(source.normalized, rng);
    }

    @Override
    public double sample() {
        return this.standardDeviation * this.normalized.sample() + this.mean;
    }

    public String toString() {
        return "Gaussian deviate [" + this.normalized.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new GaussianSampler(rng, this);
    }

    public static SharedStateContinuousSampler of(NormalizedGaussianSampler normalized, double mean, double standardDeviation) {
        return new GaussianSampler(normalized, mean, standardDeviation);
    }
}

