/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class LargeMeanPoissonSampler
implements DiscreteSampler {
    private static final InternalUtils.FactorialLog NO_CACHE_FACTORIAL_LOG = InternalUtils.FactorialLog.create();
    private final UniformRandomProvider rng;
    private final ContinuousSampler exponential;
    private final ContinuousSampler gaussian;
    private final InternalUtils.FactorialLog factorialLog;
    private final double lambda;
    private final double lambdaFractional;
    private final double logLambda;
    private final double logLambdaFactorial;
    private final double delta;
    private final double halfDelta;
    private final double twolpd;
    private final double p1;
    private final double p2;
    private final double c1;
    private final DiscreteSampler smallMeanPoissonSampler;

    public LargeMeanPoissonSampler(UniformRandomProvider rng, double mean) {
        this.rng = rng;
        if (mean <= 0.0) {
            throw new IllegalArgumentException(mean + " <= " + 0);
        }
        this.gaussian = new ZigguratNormalizedGaussianSampler(rng);
        this.exponential = new AhrensDieterExponentialSampler(rng, 1.0);
        this.factorialLog = NO_CACHE_FACTORIAL_LOG;
        this.lambda = Math.floor(mean);
        this.lambdaFractional = mean - this.lambda;
        this.logLambda = Math.log(this.lambda);
        this.logLambdaFactorial = this.factorialLog((int)this.lambda);
        this.delta = Math.sqrt(this.lambda * Math.log(32.0 * this.lambda / Math.PI + 1.0));
        this.halfDelta = this.delta / 2.0;
        this.twolpd = 2.0 * this.lambda + this.delta;
        this.c1 = 1.0 / (8.0 * this.lambda);
        double a1 = Math.sqrt(Math.PI * this.twolpd) * Math.exp(this.c1);
        double a2 = this.twolpd / this.delta * Math.exp(-this.delta * (1.0 + this.delta) / this.twolpd);
        double aSum = a1 + a2 + 1.0;
        this.p1 = a1 / aSum;
        this.p2 = a2 / aSum;
        this.smallMeanPoissonSampler = this.lambdaFractional < Double.MIN_VALUE ? null : new SmallMeanPoissonSampler(rng, this.lambdaFractional);
    }

    @Override
    public int sample() {
        double y;
        int y2;
        block6: {
            y2 = this.smallMeanPoissonSampler == null ? 0 : this.smallMeanPoissonSampler.sample();
            double x = 0.0;
            y = 0.0;
            double v = 0.0;
            boolean a = false;
            double t = 0.0;
            double qr = 0.0;
            double qa = 0.0;
            while (true) {
                double u;
                if ((u = this.rng.nextDouble()) <= this.p1) {
                    double n = this.gaussian.sample();
                    x = n * Math.sqrt(this.lambda + this.halfDelta) - 0.5;
                    if (x > this.delta || x < -this.lambda) continue;
                    y = x < 0.0 ? Math.floor(x) : Math.ceil(x);
                    double e = this.exponential.sample();
                    v = -e - 0.5 * n * n + this.c1;
                } else {
                    if (u > this.p1 + this.p2) {
                        y = this.lambda;
                        break block6;
                    }
                    x = this.delta + this.twolpd / this.delta * this.exponential.sample();
                    y = Math.ceil(x);
                    v = -this.exponential.sample() - this.delta * (x + 1.0) / this.twolpd;
                }
                a = x < 0.0;
                t = y * (y + 1.0) / (2.0 * this.lambda);
                if (v < -t && !a) {
                    y = this.lambda + y;
                    break block6;
                }
                qr = t * ((2.0 * y + 1.0) / (6.0 * this.lambda) - 1.0);
                qa = qr - t * t / (3.0 * (this.lambda + (double)a * (y + 1.0)));
                if (v < qa) {
                    y = this.lambda + y;
                    break block6;
                }
                if (!(v > qr) && v < y * this.logLambda - this.factorialLog((int)(y + this.lambda)) + this.logLambdaFactorial) break;
            }
            y = this.lambda + y;
        }
        return (int)Math.min((long)y2 + (long)y, Integer.MAX_VALUE);
    }

    private double factorialLog(int n) {
        return this.factorialLog.value(n);
    }

    public String toString() {
        return "Large Mean Poisson deviate [" + this.rng.toString() + "]";
    }
}

