/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.sampling;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import picocli.CommandLine;

class ManifestVersionProvider
implements CommandLine.IVersionProvider {
    ManifestVersionProvider() {
    }

    public String[] getVersion() throws Exception {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Manifest manifest = new Manifest(url.openStream());
                if (!ManifestVersionProvider.isApplicableManifest(manifest)) continue;
                Attributes attr = manifest.getMainAttributes();
                return new String[]{ManifestVersionProvider.get(attr, "Implementation-Title") + " version \"" + ManifestVersionProvider.get(attr, "Implementation-Version") + "\""};
            }
            catch (IOException ex) {
                return new String[]{"Unable to read from " + url + ". " + ex};
            }
        }
        return new String[0];
    }

    private static boolean isApplicableManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        return "org.apache.commons.rng.examples.sampling".equals(ManifestVersionProvider.get(attributes, "Automatic-Module-Name"));
    }

    private static Object get(Attributes attributes, String key) {
        return attributes.get(new Attributes.Name(key));
    }
}

