/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.regression;

import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.LUDecomposition;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;
import org.apache.commons.math4.legacy.stat.regression.AbstractMultipleLinearRegression;

public class GLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private RealMatrix omega;
    private RealMatrix omegaInverse;

    public void newSampleData(double[] y, double[][] x, double[][] covariance) {
        this.validateSampleData(x, y);
        this.newYSampleData(y);
        this.newXSampleData(x);
        this.validateCovarianceData(x, covariance);
        this.newCovarianceData(covariance);
    }

    protected void newCovarianceData(double[][] omega) {
        this.omega = new Array2DRowRealMatrix(omega);
        this.omegaInverse = null;
    }

    protected RealMatrix getOmegaInverse() {
        if (this.omegaInverse == null) {
            this.omegaInverse = new LUDecomposition(this.omega).getSolver().getInverse();
        }
        return this.omegaInverse;
    }

    @Override
    protected RealVector calculateBeta() {
        RealMatrix oi = this.getOmegaInverse();
        RealMatrix xt = this.getX().transpose();
        RealMatrix xtoix = xt.multiply(oi).multiply(this.getX());
        RealMatrix inverse = new LUDecomposition(xtoix).getSolver().getInverse();
        return inverse.multiply(xt).multiply(oi).operate(this.getY());
    }

    @Override
    protected RealMatrix calculateBetaVariance() {
        RealMatrix oi = this.getOmegaInverse();
        RealMatrix xtoix = this.getX().transpose().multiply(oi).multiply(this.getX());
        return new LUDecomposition(xtoix).getSolver().getInverse();
    }

    @Override
    protected double calculateErrorVariance() {
        RealVector residuals = this.calculateResiduals();
        double t = residuals.dotProduct(this.getOmegaInverse().operate(residuals));
        return t / (double)(this.getX().getRowDimension() - this.getX().getColumnDimension());
    }
}

