/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.filter;

import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.filter.ProcessModel;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;

public class DefaultProcessModel
implements ProcessModel {
    private final RealMatrix stateTransitionMatrix;
    private final RealMatrix controlMatrix;
    private final RealMatrix processNoiseCovMatrix;
    private final RealVector initialStateEstimateVector;
    private final RealMatrix initialErrorCovMatrix;

    public DefaultProcessModel(double[][] stateTransition, double[][] control, double[][] processNoise, double[] initialStateEstimate, double[][] initialErrorCovariance) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this(new Array2DRowRealMatrix(stateTransition), new Array2DRowRealMatrix(control), new Array2DRowRealMatrix(processNoise), new ArrayRealVector(initialStateEstimate), new Array2DRowRealMatrix(initialErrorCovariance));
    }

    public DefaultProcessModel(double[][] stateTransition, double[][] control, double[][] processNoise) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this(new Array2DRowRealMatrix(stateTransition), new Array2DRowRealMatrix(control), new Array2DRowRealMatrix(processNoise), null, null);
    }

    public DefaultProcessModel(RealMatrix stateTransition, RealMatrix control, RealMatrix processNoise, RealVector initialStateEstimate, RealMatrix initialErrorCovariance) {
        this.stateTransitionMatrix = stateTransition;
        this.controlMatrix = control;
        this.processNoiseCovMatrix = processNoise;
        this.initialStateEstimateVector = initialStateEstimate;
        this.initialErrorCovMatrix = initialErrorCovariance;
    }

    @Override
    public RealMatrix getStateTransitionMatrix() {
        return this.stateTransitionMatrix;
    }

    @Override
    public RealMatrix getControlMatrix() {
        return this.controlMatrix;
    }

    @Override
    public RealMatrix getProcessNoise() {
        return this.processNoiseCovMatrix;
    }

    @Override
    public RealVector getInitialStateEstimate() {
        return this.initialStateEstimateVector;
    }

    @Override
    public RealMatrix getInitialErrorCovariance() {
        return this.initialErrorCovMatrix;
    }
}

