/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.interpolation;

import org.apache.commons.math4.legacy.analysis.BivariateFunction;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.numbers.core.Sum;

class BicubicFunction
implements BivariateFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];
    private final BivariateFunction partialDerivativeX;
    private final BivariateFunction partialDerivativeY;
    private final BivariateFunction partialDerivativeXX;
    private final BivariateFunction partialDerivativeYY;
    private final BivariateFunction partialDerivativeXY;

    BicubicFunction(double[] coeff, double xR, double yR, boolean initializeDerivatives) {
        for (int j = 0; j < 4; ++j) {
            double[] aJ = this.a[j];
            for (int i = 0; i < 4; ++i) {
                aJ[i] = coeff[i * 4 + j];
            }
        }
        if (initializeDerivatives) {
            double[][] aX = new double[4][4];
            double[][] aY = new double[4][4];
            double[][] aXX = new double[4][4];
            double[][] aYY = new double[4][4];
            double[][] aXY = new double[4][4];
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    double c = this.a[i][j];
                    aX[i][j] = (double)i * c;
                    aY[i][j] = (double)j * c;
                    aXX[i][j] = (double)(i - 1) * aX[i][j];
                    aYY[i][j] = (double)(j - 1) * aY[i][j];
                    aXY[i][j] = (double)j * aX[i][j];
                }
            }
            this.partialDerivativeX = (x, y) -> {
                double x2 = x * x;
                double[] pX = new double[]{0.0, 1.0, x, x2};
                double y2 = y * y;
                double y3 = y2 * y;
                double[] pY = new double[]{1.0, y, y2, y3};
                return BicubicFunction.apply(pX, 1, pY, 0, aX) / xR;
            };
            this.partialDerivativeY = (x, y) -> {
                double x2 = x * x;
                double x3 = x2 * x;
                double[] pX = new double[]{1.0, x, x2, x3};
                double y2 = y * y;
                double[] pY = new double[]{0.0, 1.0, y, y2};
                return BicubicFunction.apply(pX, 0, pY, 1, aY) / yR;
            };
            this.partialDerivativeXX = (x, y) -> {
                double[] pX = new double[]{0.0, 0.0, 1.0, x};
                double y2 = y * y;
                double y3 = y2 * y;
                double[] pY = new double[]{1.0, y, y2, y3};
                return BicubicFunction.apply(pX, 2, pY, 0, aXX) / (xR * xR);
            };
            this.partialDerivativeYY = (x, y) -> {
                double x2 = x * x;
                double x3 = x2 * x;
                double[] pX = new double[]{1.0, x, x2, x3};
                double[] pY = new double[]{0.0, 0.0, 1.0, y};
                return BicubicFunction.apply(pX, 0, pY, 2, aYY) / (yR * yR);
            };
            this.partialDerivativeXY = (x, y) -> {
                double x2 = x * x;
                double[] pX = new double[]{0.0, 1.0, x, x2};
                double y2 = y * y;
                double[] pY = new double[]{0.0, 1.0, y, y2};
                return BicubicFunction.apply(pX, 1, pY, 1, aXY) / (xR * yR);
            };
        } else {
            this.partialDerivativeX = null;
            this.partialDerivativeY = null;
            this.partialDerivativeXX = null;
            this.partialDerivativeYY = null;
            this.partialDerivativeXY = null;
        }
    }

    @Override
    public double value(double x, double y) {
        if (x < 0.0 || x > 1.0) {
            throw new OutOfRangeException((Number)x, (Number)0, (Number)1);
        }
        if (y < 0.0 || y > 1.0) {
            throw new OutOfRangeException((Number)y, (Number)0, (Number)1);
        }
        double x2 = x * x;
        double x3 = x2 * x;
        double[] pX = new double[]{1.0, x, x2, x3};
        double y2 = y * y;
        double y3 = y2 * y;
        double[] pY = new double[]{1.0, y, y2, y3};
        return BicubicFunction.apply(pX, 0, pY, 0, this.a);
    }

    private static double apply(double[] pX, int i, double[] pY, int j, double[][] coeff) {
        double result = BicubicFunction.sumOfProducts(coeff[i], pY, j);
        while (++i < 4) {
            double r = BicubicFunction.sumOfProducts(coeff[i], pY, j);
            result += r * pX[i];
        }
        return result;
    }

    private static double sumOfProducts(double[] a, double[] b, int j) {
        Sum sum = Sum.of((double)a[j]);
        while (++j < 4) {
            sum.addProduct(a[j], b[j]);
        }
        return sum.getAsDouble();
    }

    BivariateFunction partialDerivativeX() {
        return this.partialDerivativeX;
    }

    BivariateFunction partialDerivativeY() {
        return this.partialDerivativeY;
    }

    BivariateFunction partialDerivativeXX() {
        return this.partialDerivativeXX;
    }

    BivariateFunction partialDerivativeYY() {
        return this.partialDerivativeYY;
    }

    BivariateFunction partialDerivativeXY() {
        return this.partialDerivativeXY;
    }
}

