/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.apache.commons.jcs.jcache.JCSCachingManager;

public class JCSCachingProvider
implements CachingProvider {
    public static final URI DEFAULT_URI = URI.create("jcs://jcache.ccf");
    private final ConcurrentMap<ClassLoader, ConcurrentMap<URI, CacheManager>> cacheManagersByLoader = new ConcurrentHashMap<ClassLoader, ConcurrentMap<URI, CacheManager>>();

    public CacheManager getCacheManager(URI inUri, ClassLoader inClassLoader, Properties properties) {
        CacheManager existing;
        CacheManager mgr;
        ConcurrentMap existingManagers;
        URI uri = inUri != null ? inUri : this.getDefaultURI();
        ClassLoader classLoader = inClassLoader != null ? inClassLoader : this.getDefaultClassLoader();
        ConcurrentMap<URI, CacheManager> managers = (ConcurrentHashMap)this.cacheManagersByLoader.get(classLoader);
        if (managers == null && (existingManagers = (ConcurrentMap)this.cacheManagersByLoader.putIfAbsent(classLoader, managers = new ConcurrentHashMap())) != null) {
            managers = existingManagers;
        }
        if ((mgr = (CacheManager)managers.get(uri)) == null && (existing = managers.putIfAbsent(uri, mgr = new JCSCachingManager(this, uri, classLoader, properties))) != null) {
            mgr = existing;
        }
        return mgr;
    }

    public URI getDefaultURI() {
        return DEFAULT_URI;
    }

    public void close() {
        for (Map v : this.cacheManagersByLoader.values()) {
            for (CacheManager m : v.values()) {
                m.close();
            }
            v.clear();
        }
        this.cacheManagersByLoader.clear();
    }

    public void close(ClassLoader classLoader) {
        Map cacheManagers = (Map)this.cacheManagersByLoader.remove(classLoader);
        if (cacheManagers != null) {
            for (CacheManager mgr : cacheManagers.values()) {
                mgr.close();
            }
            cacheManagers.clear();
        }
    }

    public void close(URI uri, ClassLoader classLoader) {
        CacheManager mgr;
        Map cacheManagers = (Map)this.cacheManagersByLoader.remove(classLoader);
        if (cacheManagers != null && (mgr = (CacheManager)cacheManagers.remove(uri)) != null) {
            mgr.close();
        }
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return optionalFeature == OptionalFeature.STORE_BY_REFERENCE;
    }

    public ClassLoader getDefaultClassLoader() {
        return JCSCachingProvider.class.getClassLoader();
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    void remove(CacheManager mgr) {
        ClassLoader classLoader = mgr.getClassLoader();
        Map mgrs = (Map)this.cacheManagersByLoader.get(classLoader);
        if (mgrs != null) {
            mgrs.remove(mgr.getURI());
            if (mgrs.isEmpty()) {
                this.cacheManagersByLoader.remove(classLoader);
            }
        }
    }
}

