/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.openjpa;

import java.util.Map;
import org.apache.commons.jcs.jcache.openjpa.OpenJPAJCacheDataCache;
import org.apache.commons.jcs.jcache.openjpa.OpenJPAJCacheDataCacheManager;
import org.apache.commons.jcs.jcache.openjpa.OpenJPAJCacheQueryCache;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.event.SingleJVMRemoteCommitProvider;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;

public class OpenJPAJCacheDerivation
extends AbstractProductDerivation {
    private static final String JCACHE_NAME = "jcache";

    public boolean beforeConfigurationLoad(Configuration conf) {
        if (OpenJPAConfiguration.class.isInstance(conf)) {
            OpenJPAConfigurationImpl oconf = (OpenJPAConfigurationImpl)OpenJPAConfigurationImpl.class.cast(conf);
            oconf.dataCacheManagerPlugin.setAlias(JCACHE_NAME, OpenJPAJCacheDataCacheManager.class.getName());
            oconf.dataCachePlugin.setAlias(JCACHE_NAME, OpenJPAJCacheDataCache.class.getName());
            oconf.queryCachePlugin.setAlias(JCACHE_NAME, OpenJPAJCacheQueryCache.class.getName());
        }
        return super.beforeConfigurationLoad(conf);
    }

    public boolean beforeConfigurationConstruct(ConfigurationProvider cp) {
        Map props = cp.getProperties();
        Object dcm = Configurations.getProperty((String)"DataCacheManager", (Map)props);
        if (dcm != null && JCACHE_NAME.equals(dcm)) {
            if (Configurations.getProperty((String)"DataCache", (Map)props) == null) {
                cp.addProperty("openjpa.DataCache", (Object)JCACHE_NAME);
            }
            if (Configurations.getProperty((String)"QueryCache", (Map)props) == null) {
                cp.addProperty("openjpa.QueryCache", (Object)JCACHE_NAME);
            }
            if (Configurations.getProperty((String)"RemoteCommitProvider", (Map)props) == null) {
                cp.addProperty("openjpa.RemoteCommitProvider", (Object)SingleJVMRemoteCommitProvider.class.getName());
            }
        }
        return super.beforeConfigurationConstruct(cp);
    }

    public int getType() {
        return 1000;
    }
}

