/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class InMemoryResponse
extends HttpServletResponseWrapper
implements Serializable {
    private final OutputStream buffer;
    private final Collection<Cookie> cookies = new CopyOnWriteArraySet<Cookie>();
    private final Map<String, List<Serializable>> headers = new TreeMap<String, List<Serializable>>(String.CASE_INSENSITIVE_ORDER);
    private int status = 200;
    private String contentType = null;
    private PrintWriter writer;
    private int contentLength;

    public InMemoryResponse(HttpServletResponse response, OutputStream baos) {
        super(response);
        this.buffer = baos;
    }

    private List<Serializable> ensureHeaderExists(String s) {
        List<Serializable> values = this.headers.get(s);
        if (values == null) {
            values = new LinkedList<Serializable>();
            this.headers.put(s, values);
        }
        return values;
    }

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        this.cookies.add(cookie);
    }

    public void addDateHeader(String s, long l) {
        super.addDateHeader(s, l);
        this.ensureHeaderExists(s).add(Long.valueOf(l));
    }

    public void addHeader(String s, String s2) {
        super.addHeader(s, s2);
        this.ensureHeaderExists(s).add((Serializable)((Object)s2));
    }

    public void addIntHeader(String s, int i) {
        super.addIntHeader(s, i);
        this.ensureHeaderExists(s).add(Integer.valueOf(i));
    }

    public boolean containsHeader(String s) {
        return this.headers.containsKey(s);
    }

    public String getHeader(String s) {
        List<Serializable> serializables = this.headers.get(s);
        if (serializables.isEmpty()) {
            return null;
        }
        return serializables.iterator().next().toString();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeaders(String s) {
        List<Serializable> serializables = this.headers.get(s);
        ArrayList<String> strings = new ArrayList<String>(serializables.size());
        for (Serializable ser : serializables) {
            strings.add(ser.toString());
        }
        return strings;
    }

    public int getStatus() {
        return this.status;
    }

    public void sendError(int i) throws IOException {
        this.status = i;
        super.sendError(i);
    }

    public void sendError(int i, String s) throws IOException {
        this.status = i;
        super.sendError(i, s);
    }

    public void sendRedirect(String s) throws IOException {
        this.status = 302;
        super.sendRedirect(s);
    }

    public void setDateHeader(String s, long l) {
        super.setDateHeader(s, l);
        List<Serializable> serializables = this.ensureHeaderExists(s);
        serializables.clear();
        serializables.add(Long.valueOf(l));
    }

    public void setHeader(String s, String s2) {
        super.setHeader(s, s2);
        List<Serializable> serializables = this.ensureHeaderExists(s);
        serializables.clear();
        serializables.add((Serializable)((Object)s2));
    }

    public void setIntHeader(String s, int i) {
        super.setIntHeader(s, i);
        List<Serializable> serializables = this.ensureHeaderExists(s);
        serializables.clear();
        serializables.add(Integer.valueOf(i));
    }

    public void setStatus(int i) {
        this.status = i;
        super.setStatus(i);
    }

    public void setStatus(int i, String s) {
        this.status = i;
        super.setStatus(i, s);
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                InMemoryResponse.this.buffer.write(b);
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.buffer, this.getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void reset() {
        super.reset();
        this.status = 200;
        this.headers.clear();
        this.cookies.clear();
        this.contentType = null;
        this.contentLength = 0;
    }

    public void setContentLength(int i) {
        super.setContentLength(i);
        this.contentLength = i;
    }

    public void setContentType(String s) {
        this.contentType = s;
        super.setContentType(s);
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else {
            this.buffer.flush();
        }
        super.flushBuffer();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, List<Serializable>> getHeaders() {
        return this.headers;
    }
}

