/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.junit.Assert;
import org.junit.Test;

public class JiraCsv203Test {
    @Test
    public void testQuoteModeAll() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withNullString("N/A").withIgnoreSurroundingSpaces(true).withQuoteMode(QuoteMode.ALL);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{null, "Hello", null, "World"});
        Assert.assertEquals((Object)"\"N/A\",\"Hello\",\"N/A\",\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testQuoteModeAllNonNull() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withNullString("N/A").withIgnoreSurroundingSpaces(true).withQuoteMode(QuoteMode.ALL_NON_NULL);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{null, "Hello", null, "World"});
        Assert.assertEquals((Object)"N/A,\"Hello\",N/A,\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testWithoutQuoteMode() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withNullString("N/A").withIgnoreSurroundingSpaces(true);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{null, "Hello", null, "World"});
        Assert.assertEquals((Object)"N/A,Hello,N/A,World\r\n", (Object)buffer.toString());
    }

    @Test
    public void testQuoteModeMinimal() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withNullString("N/A").withIgnoreSurroundingSpaces(true).withQuoteMode(QuoteMode.MINIMAL);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{null, "Hello", null, "World"});
        Assert.assertEquals((Object)"N/A,Hello,N/A,World\r\n", (Object)buffer.toString());
    }

    @Test
    public void testQuoteModeNonNumeric() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withNullString("N/A").withIgnoreSurroundingSpaces(true).withQuoteMode(QuoteMode.NON_NUMERIC);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{null, "Hello", null, "World"});
        Assert.assertEquals((Object)"N/A,\"Hello\",N/A,\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testWithoutNullString() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withIgnoreSurroundingSpaces(true).withQuoteMode(QuoteMode.ALL);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{null, "Hello", null, "World"});
        Assert.assertEquals((Object)",\"Hello\",,\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testWithEmptyValues() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.withNullString("N/A").withIgnoreSurroundingSpaces(true).withQuoteMode(QuoteMode.ALL);
        StringBuffer buffer = new StringBuffer();
        CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);
        printer.printRecord(new Object[]{"", "Hello", "", "World"});
        Assert.assertEquals((Object)"\"\",\"Hello\",\"\",\"World\"\r\n", (Object)buffer.toString());
    }
}

