/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.csv.Utils;
import org.apache.commons.io.FileUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CSVPrinterTest {
    private static final char EURO_CH = '\u20ac';
    private static final char DQUOTE_CHAR = '\"';
    private static final char BACKSLASH_CH = '\\';
    private static final char QUOTE_CH = '\'';
    private static final int ITERATIONS_FOR_RANDOM_TEST = 50000;
    private final String recordSeparator = CSVFormat.DEFAULT.getRecordSeparator();

    private static String printable(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= ' ' || ch >= '\u0080') {
                sb.append("(").append((int)ch).append(")");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private void doOneRandom(CSVFormat format) throws Exception {
        Random r = new Random();
        int nLines = r.nextInt(4) + 1;
        int nCol = r.nextInt(3) + 1;
        String[][] lines = this.generateLines(nLines, nCol);
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            for (int i = 0; i < nLines; ++i) {
                printer.printRecord((Object[])lines[i]);
            }
            printer.flush();
        }
        String result = sw.toString();
        try (CSVParser parser = CSVParser.parse((String)result, (CSVFormat)format);){
            List parseResult = parser.getRecords();
            String[][] expected = (String[][])lines.clone();
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = this.expectNulls(expected[i], format);
            }
            Utils.compare("Printer output :" + CSVPrinterTest.printable(result), expected, parseResult);
        }
    }

    private void doRandom(CSVFormat format, int iter) throws Exception {
        for (int i = 0; i < iter; ++i) {
            this.doOneRandom(format);
        }
    }

    private <T> T[] expectNulls(T[] original, CSVFormat csvFormat) {
        Object[] fixed = (Object[])original.clone();
        for (int i = 0; i < fixed.length; ++i) {
            if (!Objects.equals(csvFormat.getNullString(), fixed[i])) continue;
            fixed[i] = null;
        }
        return fixed;
    }

    private Connection geH2Connection() throws SQLException, ClassNotFoundException {
        Class.forName("org.h2.Driver");
        return DriverManager.getConnection("jdbc:h2:mem:my_test;", "sa", "");
    }

    private String[][] generateLines(int nLines, int nCol) {
        String[][] lines = new String[nLines][];
        for (int i = 0; i < nLines; ++i) {
            String[] line = new String[nCol];
            lines[i] = line;
            for (int j = 0; j < nCol; ++j) {
                line[j] = this.randStr();
            }
        }
        return lines;
    }

    private CSVPrinter printWithHeaderComments(StringWriter sw, Date now, CSVFormat baseFormat) throws IOException {
        CSVFormat format = baseFormat;
        format = format.withHeaderComments(new Object[]{"Generated by Apache Commons CSV 1.1", now});
        format = format.withCommentMarker('#');
        format = format.withHeader(new String[]{"Col1", "Col2"});
        CSVPrinter csvPrinter = format.print((Appendable)sw);
        csvPrinter.printRecord(new Object[]{"A", "B"});
        csvPrinter.printRecord(new Object[]{"C", "D"});
        csvPrinter.close();
        return csvPrinter;
    }

    private String randStr() {
        Random r = new Random();
        int sz = r.nextInt(20);
        char[] buf = new char[sz];
        for (int i = 0; i < sz; ++i) {
            int ch;
            int what = r.nextInt(20);
            switch (what) {
                case 0: {
                    ch = 13;
                    break;
                }
                case 1: {
                    ch = 10;
                    break;
                }
                case 2: {
                    ch = 9;
                    break;
                }
                case 3: {
                    ch = 12;
                    break;
                }
                case 4: {
                    ch = 32;
                    break;
                }
                case 5: {
                    ch = 44;
                    break;
                }
                case 6: {
                    ch = 34;
                    break;
                }
                case 7: {
                    ch = 39;
                    break;
                }
                case 8: {
                    ch = 92;
                    break;
                }
                default: {
                    ch = (char)r.nextInt(300);
                }
            }
            buf[i] = ch;
        }
        return new String(buf);
    }

    private void setUpTable(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
            statement.execute("insert into TEST values(1, 'r1')");
            statement.execute("insert into TEST values(2, 'r2')");
        }
    }

    @Test
    public void testDelimeterQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"a,b,c");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"'a,b,c',xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testDelimeterQuoteNONE() throws IOException {
        StringWriter sw = new StringWriter();
        CSVFormat format = CSVFormat.DEFAULT.withEscape('!').withQuoteMode(QuoteMode.NONE);
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            printer.print((Object)"a,b,c");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"a!,b!,c,xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testDelimiterEscaped() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape('!').withQuote(null));){
            printer.print((Object)"a,b,c");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"a!,b!,c,xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testDelimiterPlain() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));){
            printer.print((Object)"a,b,c");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"a,b,c,xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testDisabledComment() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printComment("This is a comment");
            Assert.assertEquals((Object)"", (Object)sw.toString());
        }
    }

    @Test
    public void testEOLEscaped() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withEscape('!'));){
            printer.print((Object)"a\rb\nc");
            printer.print((Object)"x\fy\bz");
            Assert.assertEquals((Object)"a!rb!nc,x\fy\bz", (Object)sw.toString());
        }
    }

    @Test
    public void testEOLPlain() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));){
            printer.print((Object)"a\rb\nc");
            printer.print((Object)"x\fy\bz");
            Assert.assertEquals((Object)"a\rb\nc,x\fy\bz", (Object)sw.toString());
        }
    }

    @Test
    public void testEOLQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"a\rb\nc");
            printer.print((Object)"x\by\fz");
            Assert.assertEquals((Object)"'a\rb\nc',x\by\fz", (Object)sw.toString());
        }
    }

    @Test
    public void testEscapeBackslash1() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"\\");
        }
        Assert.assertEquals((Object)"\\", (Object)sw.toString());
    }

    @Test
    public void testEscapeBackslash2() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"\\\r");
        }
        Assert.assertEquals((Object)"'\\\r'", (Object)sw.toString());
    }

    @Test
    public void testEscapeBackslash3() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"X\\\r");
        }
        Assert.assertEquals((Object)"'X\\\r'", (Object)sw.toString());
    }

    @Test
    public void testEscapeBackslash4() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"\\\\");
        }
        Assert.assertEquals((Object)"\\\\", (Object)sw.toString());
    }

    @Test
    public void testEscapeBackslash5() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"\\\\");
        }
        Assert.assertEquals((Object)"\\\\", (Object)sw.toString());
    }

    @Test
    public void testEscapeNull1() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape(null));){
            printer.print((Object)"\\");
        }
        Assert.assertEquals((Object)"\\", (Object)sw.toString());
    }

    @Test
    public void testEscapeNull2() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape(null));){
            printer.print((Object)"\\\r");
        }
        Assert.assertEquals((Object)"\"\\\r\"", (Object)sw.toString());
    }

    @Test
    public void testEscapeNull3() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape(null));){
            printer.print((Object)"X\\\r");
        }
        Assert.assertEquals((Object)"\"X\\\r\"", (Object)sw.toString());
    }

    @Test
    public void testEscapeNull4() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape(null));){
            printer.print((Object)"\\\\");
        }
        Assert.assertEquals((Object)"\\\\", (Object)sw.toString());
    }

    @Test
    public void testEscapeNull5() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape(null));){
            printer.print((Object)"\\\\");
        }
        Assert.assertEquals((Object)"\\\\", (Object)sw.toString());
    }

    @Test
    public void testExcelPrintAllArrayOfArrays() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);){
            printer.printRecords((Object[])new String[][]{{"r1c1", "r1c2"}, {"r2c1", "r2c2"}});
            Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testExcelPrintAllArrayOfLists() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);){
            printer.printRecords((Object[])new List[]{Arrays.asList("r1c1", "r1c2"), Arrays.asList("r2c1", "r2c2")});
            Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testExcelPrintAllIterableOfArrays() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);){
            printer.printRecords(Arrays.asList({"r1c1", "r1c2"}, {"r2c1", "r2c2"}));
            Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testExcelPrintAllIterableOfLists() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);){
            printer.printRecords(Arrays.asList(Arrays.asList("r1c1", "r1c2"), Arrays.asList("r2c1", "r2c2")));
            Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testExcelPrinter1() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);){
            printer.printRecord(new Object[]{"a", "b"});
            Assert.assertEquals((Object)("a,b" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testExcelPrinter2() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);){
            printer.printRecord(new Object[]{"a,b", "b"});
            Assert.assertEquals((Object)("\"a,b\",b" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testHeader() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withHeader(new String[]{"C1", "C2", "C3"}));){
            printer.printRecord(new Object[]{"a", "b", "c"});
            printer.printRecord(new Object[]{"x", "y", "z"});
            Assert.assertEquals((Object)"C1,C2,C3\r\na,b,c\r\nx,y,z\r\n", (Object)sw.toString());
        }
    }

    @Test
    public void testHeaderCommentExcel() throws IOException {
        StringWriter sw = new StringWriter();
        Date now = new Date();
        CSVFormat format = CSVFormat.EXCEL;
        try (CSVPrinter csvPrinter = this.printWithHeaderComments(sw, now, format);){
            Assert.assertEquals((Object)("# Generated by Apache Commons CSV 1.1\r\n# " + now + "\r\nCol1,Col2\r\nA,B\r\nC,D\r\n"), (Object)sw.toString());
        }
    }

    @Test
    public void testHeaderCommentTdf() throws IOException {
        StringWriter sw = new StringWriter();
        Date now = new Date();
        CSVFormat format = CSVFormat.TDF;
        try (CSVPrinter csvPrinter = this.printWithHeaderComments(sw, now, format);){
            Assert.assertEquals((Object)("# Generated by Apache Commons CSV 1.1\r\n# " + now + "\r\nCol1\tCol2\r\nA\tB\r\nC\tD\r\n"), (Object)sw.toString());
        }
    }

    @Test
    public void testHeaderNotSet() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));){
            printer.printRecord(new Object[]{"a", "b", "c"});
            printer.printRecord(new Object[]{"x", "y", "z"});
            Assert.assertEquals((Object)"a,b,c\r\nx,y,z\r\n", (Object)sw.toString());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidFormat() throws Exception {
        CSVFormat invalidFormat = CSVFormat.DEFAULT.withDelimiter('\r');
        try (CSVPrinter printer = new CSVPrinter((Appendable)new StringWriter(), invalidFormat);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test
    public void testJdbcPrinter() throws IOException, ClassNotFoundException, SQLException {
        StringWriter sw = new StringWriter();
        try (Connection connection = this.geH2Connection();){
            this.setUpTable(connection);
            try (Statement stmt = connection.createStatement();
                 CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
                printer.printRecords(stmt.executeQuery("select ID, NAME from TEST"));
            }
        }
        Assert.assertEquals((Object)("1,r1" + this.recordSeparator + "2,r2" + this.recordSeparator), (Object)sw.toString());
    }

    @Test
    public void testJdbcPrinterWithResultSet() throws IOException, ClassNotFoundException, SQLException {
        StringWriter sw = new StringWriter();
        Class.forName("org.h2.Driver");
        try (Connection connection = this.geH2Connection();){
            this.setUpTable(connection);
            try (Statement stmt = connection.createStatement();
                 ResultSet resultSet = stmt.executeQuery("select ID, NAME from TEST");
                 CSVPrinter printer = CSVFormat.DEFAULT.withHeader(resultSet).print((Appendable)sw);){
                printer.printRecords(resultSet);
            }
        }
        Assert.assertEquals((Object)("ID,NAME" + this.recordSeparator + "1,r1" + this.recordSeparator + "2,r2" + this.recordSeparator), (Object)sw.toString());
    }

    @Test
    public void testJdbcPrinterWithResultSetMetaData() throws IOException, ClassNotFoundException, SQLException {
        StringWriter sw = new StringWriter();
        Class.forName("org.h2.Driver");
        try (Connection connection = this.geH2Connection();){
            this.setUpTable(connection);
            try (Statement stmt = connection.createStatement();
                 ResultSet resultSet = stmt.executeQuery("select ID, NAME from TEST");
                 CSVPrinter printer = CSVFormat.DEFAULT.withHeader(resultSet.getMetaData()).print((Appendable)sw);){
                printer.printRecords(resultSet);
                Assert.assertEquals((Object)("ID,NAME" + this.recordSeparator + "1,r1" + this.recordSeparator + "2,r2" + this.recordSeparator), (Object)sw.toString());
            }
        }
    }

    @Test
    @Ignore
    public void testJira135_part1() throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.withRecordSeparator('\n').withQuote('\"').withEscape('\\');
        StringWriter sw = new StringWriter();
        LinkedList<String> list = new LinkedList<String>();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            list.add("\"");
            printer.printRecord(list);
        }
        String expected = "\"\\\"\"" + format.getRecordSeparator();
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(list.toArray(), format), (Object[])record0);
    }

    @Test
    @Ignore
    public void testJira135_part2() throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.withRecordSeparator('\n').withQuote('\"').withEscape('\\');
        StringWriter sw = new StringWriter();
        LinkedList<String> list = new LinkedList<String>();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            list.add("\n");
            printer.printRecord(list);
        }
        String expected = "\"\\n\"" + format.getRecordSeparator();
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(list.toArray(), format), (Object[])record0);
    }

    @Test
    @Ignore
    public void testJira135_part3() throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.withRecordSeparator('\n').withQuote('\"').withEscape('\\');
        StringWriter sw = new StringWriter();
        LinkedList<String> list = new LinkedList<String>();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            list.add("\\");
            printer.printRecord(list);
        }
        String expected = "\"\\\\\"" + format.getRecordSeparator();
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(list.toArray(), format), (Object[])record0);
    }

    @Test
    @Ignore
    public void testJira135All() throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.withRecordSeparator('\n').withQuote('\"').withEscape('\\');
        StringWriter sw = new StringWriter();
        LinkedList<String> list = new LinkedList<String>();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            list.add("\"");
            list.add("\n");
            list.add("\\");
            printer.printRecord(list);
        }
        String expected = "\"\\\"\",\"\\n\",\"\\\"" + format.getRecordSeparator();
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(list.toArray(), format), (Object[])record0);
    }

    @Test
    public void testMultiLineComment() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withCommentMarker('#'));){
            printer.printComment("This is a comment\non multiple lines");
            Assert.assertEquals((Object)("# This is a comment" + this.recordSeparator + "# on multiple lines" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testMySqlNullOutput() throws IOException {
        Object[] s = new String[]{"NULL", null};
        CSVFormat format = CSVFormat.MYSQL.withQuote('\"').withNullString("NULL").withQuoteMode(QuoteMode.NON_NUMERIC);
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, format);){
            printer.printRecord(s);
        }
        String expected = "\"NULL\"\tNULL\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])new Object[2], (Object[])record0);
        s = new String[]{"\\N", null};
        format = CSVFormat.MYSQL.withNullString("\\N");
        writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, format);){
            printer.printRecord(s);
        }
        expected = "\\\\N\t\\N\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\N", "A"};
        format = CSVFormat.MYSQL.withNullString("\\N");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\N\tA\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\n", "A"};
        format = CSVFormat.MYSQL.withNullString("\\N");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\n\tA\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"", null};
        format = CSVFormat.MYSQL.withNullString("NULL");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\tNULL\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"", null};
        format = CSVFormat.MYSQL;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\t\\N\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\N", "", "\u000e,\\\r"};
        format = CSVFormat.MYSQL;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\N\t\t\u000e,\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"NULL", "\\\r"};
        format = CSVFormat.MYSQL;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "NULL\t\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\\r"};
        format = CSVFormat.MYSQL;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
    }

    @Test
    @Ignore
    public void testPostgreSqlCsvNullOutput() throws IOException {
        Object[] s = new String[]{"NULL", null};
        CSVFormat format = CSVFormat.POSTGRESQL_CSV.withQuote('\"').withNullString("NULL").withQuoteMode(QuoteMode.ALL_NON_NULL);
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, format);){
            printer.printRecord(s);
        }
        String expected = "\"NULL\",NULL\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])new Object[2], (Object[])record0);
        s = new String[]{"\\N", null};
        format = CSVFormat.POSTGRESQL_CSV.withNullString("\\N");
        writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, format);){
            printer.printRecord(s);
        }
        expected = "\\\\N\t\\N\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\N", "A"};
        format = CSVFormat.POSTGRESQL_CSV.withNullString("\\N");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\N\tA\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\n", "A"};
        format = CSVFormat.POSTGRESQL_CSV.withNullString("\\N");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\n\tA\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"", null};
        format = CSVFormat.POSTGRESQL_CSV.withNullString("NULL");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\tNULL\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"", null};
        format = CSVFormat.POSTGRESQL_CSV;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\t\\N\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\N", "", "\u000e,\\\r"};
        format = CSVFormat.POSTGRESQL_CSV;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\N\t\t\u000e,\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"NULL", "\\\r"};
        format = CSVFormat.POSTGRESQL_CSV;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "NULL\t\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\\r"};
        format = CSVFormat.POSTGRESQL_CSV;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
    }

    @Test
    @Ignore
    public void testPostgreSqlCsvTextOutput() throws IOException {
        Object[] s = new String[]{"NULL", null};
        CSVFormat format = CSVFormat.POSTGRESQL_TEXT.withQuote('\"').withNullString("NULL").withQuoteMode(QuoteMode.ALL_NON_NULL);
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, format);){
            printer.printRecord(s);
        }
        String expected = "\"NULL\"\tNULL\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        Object[] record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])new Object[2], (Object[])record0);
        s = new String[]{"\\N", null};
        format = CSVFormat.POSTGRESQL_TEXT.withNullString("\\N");
        writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, format);){
            printer.printRecord(s);
        }
        expected = "\\\\N\t\\N\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\N", "A"};
        format = CSVFormat.POSTGRESQL_TEXT.withNullString("\\N");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\N\tA\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\n", "A"};
        format = CSVFormat.POSTGRESQL_TEXT.withNullString("\\N");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\n\tA\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"", null};
        format = CSVFormat.POSTGRESQL_TEXT.withNullString("NULL");
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\tNULL\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"", null};
        format = CSVFormat.POSTGRESQL_TEXT;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\t\\N\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\N", "", "\u000e,\\\r"};
        format = CSVFormat.POSTGRESQL_TEXT;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\N\t\t\u000e,\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"NULL", "\\\r"};
        format = CSVFormat.POSTGRESQL_TEXT;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "NULL\t\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
        s = new String[]{"\\\r"};
        format = CSVFormat.POSTGRESQL_TEXT;
        writer = new StringWriter();
        printer = new CSVPrinter((Appendable)writer, format);
        var7_10 = null;
        try {
            printer.printRecord(s);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (printer != null) {
                if (var7_10 != null) {
                    try {
                        printer.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    printer.close();
                }
            }
        }
        expected = "\\\\\\r\n";
        Assert.assertEquals((Object)expected, (Object)writer.toString());
        record0 = this.toFirstRecordValues(expected, format);
        Assert.assertArrayEquals((Object[])this.expectNulls(s, format), (Object[])record0);
    }

    @Test
    public void testMySqlNullStringDefault() {
        Assert.assertEquals((Object)"\\N", (Object)CSVFormat.MYSQL.getNullString());
    }

    @Test
    public void testPostgreSQLNullStringDefaultCsv() {
        Assert.assertEquals((Object)"", (Object)CSVFormat.POSTGRESQL_CSV.getNullString());
    }

    @Test
    public void testPostgreSQLNullStringDefaultText() {
        Assert.assertEquals((Object)"\\N", (Object)CSVFormat.POSTGRESQL_TEXT.getNullString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCsvPrinterAppendableNullFormat() throws Exception {
        try (CSVPrinter printer = new CSVPrinter((Appendable)new StringWriter(), null);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCSVPrinterNullAppendableFormat() throws Exception {
        try (CSVPrinter printer = new CSVPrinter(null, CSVFormat.DEFAULT);){
            Assert.fail((String)"This test should have thrown an exception.");
        }
    }

    @Test
    public void testParseCustomNullValues() throws IOException {
        StringWriter sw = new StringWriter();
        CSVFormat format = CSVFormat.DEFAULT.withNullString("NULL");
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, format);){
            printer.printRecord(new Object[]{"a", null, "b"});
        }
        String csvString = sw.toString();
        Assert.assertEquals((Object)("a,NULL,b" + this.recordSeparator), (Object)csvString);
        try (CSVParser iterable = format.parse((Reader)new StringReader(csvString));){
            Iterator iterator = iterable.iterator();
            CSVRecord record = (CSVRecord)iterator.next();
            Assert.assertEquals((Object)"a", (Object)record.get(0));
            Assert.assertEquals(null, (Object)record.get(1));
            Assert.assertEquals((Object)"b", (Object)record.get(2));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testPlainEscaped() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withEscape('!'));){
            printer.print((Object)"abc");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"abc,xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testPlainPlain() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));){
            printer.print((Object)"abc");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"abc,xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testPlainQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"abc");
            Assert.assertEquals((Object)"abc", (Object)sw.toString());
        }
    }

    @Test
    public void testPrint() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = CSVFormat.DEFAULT.print((Appendable)sw);){
            printer.printRecord(new Object[]{"a", "b\\c"});
            Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrintCustomNullValues() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withNullString("NULL"));){
            printer.printRecord(new Object[]{"a", null, "b"});
            Assert.assertEquals((Object)("a,NULL,b" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter1() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a", "b"});
            Assert.assertEquals((Object)("a,b" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testRfc4180QuoteSingleChar() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.RFC4180);){
            printer.printRecord(new Object[]{Character.valueOf('\u20ac'), "Deux"});
            Assert.assertEquals((Object)("\"\u20ac\",Deux" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter2() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a,b", "b"});
            Assert.assertEquals((Object)("\"a,b\",b" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter3() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a, b", "b "});
            Assert.assertEquals((Object)("\"a, b\",\"b \"" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter4() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a", "b\"c"});
            Assert.assertEquals((Object)("a,\"b\"\"c\"" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter5() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a", "b\nc"});
            Assert.assertEquals((Object)("a,\"b\nc\"" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter6() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a", "b\r\nc"});
            Assert.assertEquals((Object)("a,\"b\r\nc\"" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrinter7() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a", "b\\c"});
            Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrintNullValues() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
            printer.printRecord(new Object[]{"a", null, "b"});
            Assert.assertEquals((Object)("a,,b" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testPrintOnePositiveInteger() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuoteMode(QuoteMode.MINIMAL));){
            printer.print((Object)Integer.MAX_VALUE);
            Assert.assertEquals((Object)String.valueOf(Integer.MAX_VALUE), (Object)sw.toString());
        }
    }

    @Test
    public void testPrintToFileWithCharsetUtf16Be() throws IOException {
        File file = File.createTempFile(this.getClass().getName(), ".csv");
        try (CSVPrinter printer = CSVFormat.DEFAULT.print(file, StandardCharsets.UTF_16BE);){
            printer.printRecord(new Object[]{"a", "b\\c"});
        }
        Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_16BE));
    }

    @Test
    public void testPrintToFileWithDefaultCharset() throws IOException {
        File file = File.createTempFile(this.getClass().getName(), ".csv");
        try (CSVPrinter printer = CSVFormat.DEFAULT.print(file, Charset.defaultCharset());){
            printer.printRecord(new Object[]{"a", "b\\c"});
        }
        Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()));
    }

    @Test
    public void testPrintToPathWithDefaultCharset() throws IOException {
        File file = File.createTempFile(this.getClass().getName(), ".csv");
        try (CSVPrinter printer = CSVFormat.DEFAULT.print(file.toPath(), Charset.defaultCharset());){
            printer.printRecord(new Object[]{"a", "b\\c"});
        }
        Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()));
    }

    @Test
    public void testQuoteAll() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuoteMode(QuoteMode.ALL));){
            printer.printRecord(new Object[]{"a", "b\nc", "d"});
            Assert.assertEquals((Object)("\"a\",\"b\nc\",\"d\"" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testQuoteNonNumeric() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuoteMode(QuoteMode.NON_NUMERIC));){
            printer.printRecord(new Object[]{"a", "b\nc", 1});
            Assert.assertEquals((Object)("\"a\",\"b\nc\",1" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testRandomDefault() throws Exception {
        this.doRandom(CSVFormat.DEFAULT, 50000);
    }

    @Test
    public void testRandomExcel() throws Exception {
        this.doRandom(CSVFormat.EXCEL, 50000);
    }

    @Test
    public void testRandomMySql() throws Exception {
        this.doRandom(CSVFormat.MYSQL, 50000);
    }

    @Test
    @Ignore
    public void testRandomPostgreSqlCsv() throws Exception {
        this.doRandom(CSVFormat.POSTGRESQL_CSV, 50000);
    }

    @Test
    @Ignore
    public void testRandomPostgreSqlText() throws Exception {
        this.doRandom(CSVFormat.POSTGRESQL_TEXT, 50000);
    }

    @Test
    public void testRandomRfc4180() throws Exception {
        this.doRandom(CSVFormat.RFC4180, 50000);
    }

    @Test
    public void testRandomTdf() throws Exception {
        this.doRandom(CSVFormat.TDF, 50000);
    }

    @Test
    public void testSingleLineComment() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withCommentMarker('#'));){
            printer.printComment("This is a comment");
            Assert.assertEquals((Object)("# This is a comment" + this.recordSeparator), (Object)sw.toString());
        }
    }

    @Test
    public void testSingleQuoteQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));){
            printer.print((Object)"a'b'c");
            printer.print((Object)"xyz");
            Assert.assertEquals((Object)"'a''b''c',xyz", (Object)sw.toString());
        }
    }

    @Test
    public void testSkipHeaderRecordFalse() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withHeader(new String[]{"C1", "C2", "C3"}).withSkipHeaderRecord(false));){
            printer.printRecord(new Object[]{"a", "b", "c"});
            printer.printRecord(new Object[]{"x", "y", "z"});
            Assert.assertEquals((Object)"C1,C2,C3\r\na,b,c\r\nx,y,z\r\n", (Object)sw.toString());
        }
    }

    @Test
    public void testSkipHeaderRecordTrue() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withHeader(new String[]{"C1", "C2", "C3"}).withSkipHeaderRecord(true));){
            printer.printRecord(new Object[]{"a", "b", "c"});
            printer.printRecord(new Object[]{"x", "y", "z"});
            Assert.assertEquals((Object)"a,b,c\r\nx,y,z\r\n", (Object)sw.toString());
        }
    }

    @Test
    public void testTrailingDelimiterOnTwoColumns() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withTrailingDelimiter());){
            printer.printRecord(new Object[]{"A", "B"});
            Assert.assertEquals((Object)"A,B,\r\n", (Object)sw.toString());
        }
    }

    @Test
    public void testTrimOffOneColumn() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withTrim(false));){
            printer.print((Object)" A ");
            Assert.assertEquals((Object)"\" A \"", (Object)sw.toString());
        }
    }

    @Test
    public void testTrimOnOneColumn() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withTrim());){
            printer.print((Object)" A ");
            Assert.assertEquals((Object)"A", (Object)sw.toString());
        }
    }

    @Test
    public void testTrimOnTwoColumns() throws IOException {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withTrim());){
            printer.print((Object)" A ");
            printer.print((Object)" B ");
            Assert.assertEquals((Object)"A,B", (Object)sw.toString());
        }
    }

    private String[] toFirstRecordValues(String expected, CSVFormat format) throws IOException {
        return ((CSVRecord)CSVParser.parse((String)expected, (CSVFormat)format).getRecords().get(0)).values();
    }

    @Test
    public void testPrintRecordsWithResultSetOneRow() throws IOException, SQLException {
        try (CSVPrinter csvPrinter = CSVFormat.MYSQL.printer();){
            Value[] valueArray = new Value[]{};
            ValueArray valueArrayTwo = ValueArray.get((Value[])valueArray);
            try (ResultSet resultSet = valueArrayTwo.getResultSet();){
                csvPrinter.printRecords(resultSet);
                Assert.assertEquals((long)0L, (long)resultSet.getRow());
            }
        }
    }

    @Test
    public void testPrintRecordsWithObjectArray() throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter(0);
        try (CSVPrinter csvPrinter = CSVFormat.INFORMIX_UNLOAD.print((Appendable)charArrayWriter);){
            HashSet hashSet = new HashSet();
            Object[] objectArray = new Object[6];
            objectArray[3] = hashSet;
            csvPrinter.printRecords(objectArray);
        }
        Assert.assertEquals((long)6L, (long)charArrayWriter.size());
        Assert.assertEquals((Object)"\n\n\n\n\n\n", (Object)charArrayWriter.toString());
    }

    @Test
    public void testPrintRecordsWithEmptyVector() throws IOException {
        try (CSVPrinter csvPrinter = CSVFormat.POSTGRESQL_TEXT.printer();){
            Vector vector = new Vector();
            int expectedCapacity = 23;
            vector.setSize(expectedCapacity);
            csvPrinter.printRecords(vector);
            Assert.assertEquals((long)expectedCapacity, (long)vector.capacity());
        }
    }
}

