/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Lexer;
import org.apache.commons.csv.Token;
import org.apache.commons.csv.TokenMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LexerTest {
    private CSVFormat formatWithEscaping;

    @Before
    public void setUp() {
        this.formatWithEscaping = CSVFormat.DEFAULT.withEscape('\\');
    }

    private Lexer getLexer(String input, CSVFormat format) {
        return new Lexer(format, new ExtendedBufferedReader((Reader)new StringReader(input)));
    }

    @Test
    public void testSurroundingSpacesAreDeleted() throws IOException {
        String code = "noSpaces,  leadingSpaces,trailingSpaces  ,  surroundingSpaces  ,  ,,";
        Lexer parser = this.getLexer("noSpaces,  leadingSpaces,trailingSpaces  ,  surroundingSpaces  ,  ,,", CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "noSpaces"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "leadingSpaces"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "trailingSpaces"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "surroundingSpaces"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
    }

    @Test
    public void testSurroundingTabsAreDeleted() throws IOException {
        String code = "noTabs,\tleadingTab,trailingTab\t,\tsurroundingTabs\t,\t\t,,";
        Lexer parser = this.getLexer("noTabs,\tleadingTab,trailingTab\t,\tsurroundingTabs\t,\t\t,,", CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "noTabs"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "leadingTab"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "trailingTab"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "surroundingTabs"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
    }

    @Test
    public void testIgnoreEmptyLines() throws IOException {
        String code = "first,line,\n\n\nsecond,line\n\n\nthird line \n\n\nlast, line \n\n\n\n";
        CSVFormat format = CSVFormat.DEFAULT.withIgnoreEmptyLines();
        Lexer parser = this.getLexer("first,line,\n\n\nsecond,line\n\n\nthird line \n\n\nlast, line \n\n\n\n", format);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "first"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "line"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "second"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "line"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "third line "));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "last"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, " line "));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
    }

    @Test
    public void testComments() throws IOException {
        String code = "first,line,\nsecond,line,tokenWith#no-comment\n# comment line \nthird,line,#no-comment\n# penultimate comment\n# Final comment\n";
        CSVFormat format = CSVFormat.DEFAULT.withCommentMarker('#');
        Lexer parser = this.getLexer("first,line,\nsecond,line,tokenWith#no-comment\n# comment line \nthird,line,#no-comment\n# penultimate comment\n# Final comment\n", format);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "first"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "line"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "second"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "line"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "tokenWith#no-comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.COMMENT, "comment line"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "third"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "line"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "#no-comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.COMMENT, "penultimate comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.COMMENT, "Final comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
    }

    @Test
    public void testCommentsAndEmptyLines() throws IOException {
        String code = "1,2,3,\n\n\na,b x,c#no-comment\n#foo\n\n\nd,e,#no-comment\n\n\n# penultimate comment\n\n\n# Final comment\n";
        CSVFormat format = CSVFormat.DEFAULT.withCommentMarker('#').withIgnoreEmptyLines(false);
        Assert.assertFalse((String)"Should not ignore empty lines", (boolean)format.getIgnoreEmptyLines());
        Lexer parser = this.getLexer("1,2,3,\n\n\na,b x,c#no-comment\n#foo\n\n\nd,e,#no-comment\n\n\n# penultimate comment\n\n\n# Final comment\n", format);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "1"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "2"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "3"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "b x"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "c#no-comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.COMMENT, "foo"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "d"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "e"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "#no-comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.COMMENT, "penultimate comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.COMMENT, "Final comment"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
    }

    @Test
    public void testBackslashWithoutEscaping() throws IOException {
        String code = "a,\\,,b\\\n\\,,";
        CSVFormat format = CSVFormat.DEFAULT;
        Assert.assertFalse((boolean)format.isEscapeCharacterSet());
        Lexer parser = this.getLexer("a,\\,,b\\\n\\,,", format);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "\\"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b\\"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "\\"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, ""));
    }

    @Test
    public void testBackslashWithEscaping() throws IOException {
        String code = "a,\\,,b\\\\\n\\,,\\\nc,d\\\r\ne";
        CSVFormat format = this.formatWithEscaping.withIgnoreEmptyLines(false);
        Assert.assertTrue((boolean)format.isEscapeCharacterSet());
        Lexer parser = this.getLexer("a,\\,,b\\\\\n\\,,\\\nc,d\\\r\ne", format);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ","));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b\\"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ","));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "\nc"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "d\r"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, "e"));
    }

    @Test
    public void testNextToken4() throws IOException {
        String code = "a,\"foo\",b\na,   \" foo\",b\na,\"foo \"  ,b\na,  \" foo \"  ,b";
        Lexer parser = this.getLexer("a,\"foo\",b\na,   \" foo\",b\na,\"foo \"  ,b\na,  \" foo \"  ,b", CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "foo"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, " foo"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "foo "));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, " foo "));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, "b"));
    }

    @Test
    public void testNextToken5() throws IOException {
        String code = "a,\"foo\n\",b\n\"foo\n  baar ,,,\"\n\"\n\t \n\"";
        Lexer parser = this.getLexer("a,\"foo\n\",b\n\"foo\n  baar ,,,\"\n\"\n\t \n\"", CSVFormat.DEFAULT);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "foo\n"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "foo\n  baar ,,,"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, "\n\t \n"));
    }

    @Test
    public void testNextToken6() throws IOException {
        String code = "a;'b and '' more\n'\n!comment;;;;\n;;";
        CSVFormat format = CSVFormat.DEFAULT.withQuote('\'').withCommentMarker('!').withDelimiter(';');
        Lexer parser = this.getLexer("a;'b and '' more\n'\n!comment;;;;\n;;", format);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "a"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EORECORD, "b and ' more\n"));
    }

    @Test
    public void testDelimiterIsWhitespace() throws IOException {
        String code = "one\ttwo\t\tfour \t five\t six";
        Lexer parser = this.getLexer("one\ttwo\t\tfour \t five\t six", CSVFormat.TDF);
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "one"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "two"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, ""));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "four"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.TOKEN, "five"));
        Assert.assertThat((Object)parser.nextToken(new Token()), TokenMatchers.matches(Token.Type.EOF, "six"));
    }

    @Test
    public void testEscapedCR() throws Exception {
        Lexer lexer = this.getLexer("character\\\rEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\rEscaped"));
    }

    @Test
    public void testCR() throws Exception {
        Lexer lexer = this.getLexer("character\rNotEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character"));
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("NotEscaped"));
    }

    @Test
    public void testEscapedLF() throws Exception {
        Lexer lexer = this.getLexer("character\\\nEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\nEscaped"));
    }

    @Test
    public void testLF() throws Exception {
        Lexer lexer = this.getLexer("character\nNotEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character"));
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("NotEscaped"));
    }

    @Test
    public void testEscapedTab() throws Exception {
        Lexer lexer = this.getLexer("character\\\tEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\tEscaped"));
    }

    @Test
    public void testTab() throws Exception {
        Lexer lexer = this.getLexer("character\tNotEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\tNotEscaped"));
    }

    @Test
    public void testEscapedBackspace() throws Exception {
        Lexer lexer = this.getLexer("character\\\bEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\bEscaped"));
    }

    @Test
    public void testBackspace() throws Exception {
        Lexer lexer = this.getLexer("character\bNotEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\bNotEscaped"));
    }

    @Test
    public void testEscapedFF() throws Exception {
        Lexer lexer = this.getLexer("character\\\fEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\fEscaped"));
    }

    @Test
    public void testFF() throws Exception {
        Lexer lexer = this.getLexer("character\fNotEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\fNotEscaped"));
    }

    @Test
    public void testEscapedMySqlNullValue() throws Exception {
        Lexer lexer = this.getLexer("character\\NEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\\NEscaped"));
    }

    @Test
    public void testEscapedCharacter() throws Exception {
        Lexer lexer = this.getLexer("character\\aEscaped", this.formatWithEscaping);
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\\aEscaped"));
    }

    @Test
    public void testEscapedControlCharacter() throws Exception {
        Lexer lexer = this.getLexer("character!rEscaped", CSVFormat.DEFAULT.withEscape('!'));
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\rEscaped"));
    }

    @Test
    public void testEscapedControlCharacter2() throws Exception {
        Lexer lexer = this.getLexer("character\\rEscaped", CSVFormat.DEFAULT.withEscape('\\'));
        Assert.assertThat((Object)lexer.nextToken(new Token()), TokenMatchers.hasContent("character\rEscaped"));
    }

    @Test(expected=IOException.class)
    public void testEscapingAtEOF() throws Exception {
        String code = "escaping at EOF is evil\\";
        Lexer lexer = this.getLexer("escaping at EOF is evil\\", this.formatWithEscaping);
        lexer.nextToken(new Token());
    }
}

