/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv93Test {
    private static Object[] objects1 = new Object[]{"abc", "", null, "a,b,c", 123};
    private static Object[] objects2 = new Object[]{"abc", "NULL", null, "a,b,c", 123};

    private void every(CSVFormat csvFormat, Object[] objects, String format, String[] data) throws IOException {
        String source = csvFormat.format(objects);
        Assertions.assertEquals((Object)format, (Object)csvFormat.format(objects));
        try (CSVParser csvParser = csvFormat.parse((Reader)new StringReader(source));){
            CSVRecord csvRecord = (CSVRecord)csvParser.iterator().next();
            for (int i = 0; i < data.length; ++i) {
                Assertions.assertEquals((Object)csvRecord.get(i), (Object)data[i]);
            }
        }
    }

    @Test
    public void testWithNotSetNullString() throws IOException {
        this.every(CSVFormat.DEFAULT, objects1, "abc,,,\"a,b,c\",123", new String[]{"abc", "", "", "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.ALL).get(), objects1, "\"abc\",\"\",,\"a,b,c\",\"123\"", new String[]{"abc", "", "", "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.ALL_NON_NULL).get(), objects1, "\"abc\",\"\",,\"a,b,c\",\"123\"", new String[]{"abc", "", null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.MINIMAL).get(), objects1, "abc,,,\"a,b,c\",123", new String[]{"abc", "", "", "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setEscape('?').setQuoteMode(QuoteMode.NONE).get(), objects1, "abc,,,a?,b?,c,123", new String[]{"abc", "", "", "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.NON_NUMERIC).get(), objects1, "\"abc\",\"\",,\"a,b,c\",123", new String[]{"abc", "", null, "a,b,c", "123"});
    }

    @Test
    public void testWithSetNullStringEmptyString() throws IOException {
        this.every(CSVFormat.DEFAULT.builder().setNullString("").get(), objects1, "abc,,,\"a,b,c\",123", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("").setQuoteMode(QuoteMode.ALL).get(), objects1, "\"abc\",\"\",\"\",\"a,b,c\",\"123\"", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("").setQuoteMode(QuoteMode.ALL_NON_NULL).get(), objects1, "\"abc\",\"\",,\"a,b,c\",\"123\"", new String[]{"abc", "", null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("").setQuoteMode(QuoteMode.MINIMAL).get(), objects1, "abc,,,\"a,b,c\",123", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("").setEscape('?').setQuoteMode(QuoteMode.NONE).get(), objects1, "abc,,,a?,b?,c,123", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("").setQuoteMode(QuoteMode.NON_NUMERIC).get(), objects1, "\"abc\",\"\",,\"a,b,c\",123", new String[]{"abc", "", null, "a,b,c", "123"});
    }

    @Test
    public void testWithSetNullStringNULL() throws IOException {
        this.every(CSVFormat.DEFAULT.builder().setNullString("NULL").get(), objects2, "abc,NULL,NULL,\"a,b,c\",123", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("NULL").setQuoteMode(QuoteMode.ALL).get(), objects2, "\"abc\",\"NULL\",\"NULL\",\"a,b,c\",\"123\"", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("NULL").setQuoteMode(QuoteMode.ALL_NON_NULL).get(), objects2, "\"abc\",\"NULL\",NULL,\"a,b,c\",\"123\"", new String[]{"abc", "NULL", null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("NULL").setQuoteMode(QuoteMode.MINIMAL).get(), objects2, "abc,NULL,NULL,\"a,b,c\",123", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("NULL").setEscape('?').setQuoteMode(QuoteMode.NONE).get(), objects2, "abc,NULL,NULL,a?,b?,c,123", new String[]{"abc", null, null, "a,b,c", "123"});
        this.every(CSVFormat.DEFAULT.builder().setNullString("NULL").setQuoteMode(QuoteMode.NON_NUMERIC).get(), objects2, "\"abc\",\"NULL\",NULL,\"a,b,c\",123", new String[]{"abc", "NULL", null, "a,b,c", "123"});
    }
}

