/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv167Test {
    private Reader getTestReader() {
        return new InputStreamReader(ClassLoader.getSystemClassLoader().getResourceAsStream("org/apache/commons/csv/csv-167/sample1.csv"));
    }

    @Test
    public void testParse() throws IOException {
        int totcomment = 0;
        int totrecs = 0;
        try (Reader reader = this.getTestReader();
             BufferedReader br = new BufferedReader(reader);){
            String s = null;
            boolean lastWasComment = false;
            while ((s = br.readLine()) != null) {
                if (s.startsWith("#")) {
                    if (!lastWasComment) {
                        ++totcomment;
                    }
                    lastWasComment = true;
                    continue;
                }
                ++totrecs;
                lastWasComment = false;
            }
        }
        CSVFormat format = CSVFormat.DEFAULT.builder().setAllowMissingColumnNames(false).setCommentMarker('#').setDelimiter(',').setEscape('\\').setHeader(new String[]{"author", "title", "publishDate"}).setHeaderComments(new String[]{"headerComment"}).setNullString("NULL").setIgnoreEmptyLines(true).setIgnoreSurroundingSpaces(true).setQuote('\"').setQuoteMode(QuoteMode.ALL).setRecordSeparator('\n').setSkipHeaderRecord(false).get();
        int comments = 0;
        int records = 0;
        try (Reader reader = this.getTestReader();
             CSVParser parser = format.parse(reader);){
            for (CSVRecord csvRecord : parser) {
                ++records;
                if (!csvRecord.hasComment()) continue;
                ++comments;
            }
        }
        Assertions.assertEquals((int)totcomment, (int)comments);
        Assertions.assertEquals((int)totrecs, (int)records);
    }
}

