/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv290Test {
    private void testHelper(String fileName, CSVFormat format) throws Exception {
        List<Object> content = new ArrayList();
        try (CSVParser csvParser = CSVParser.parse((Reader)new InputStreamReader(this.getClass().getResourceAsStream("/org/apache/commons/csv/CSV-290/" + fileName)), (CSVFormat)format);){
            content = csvParser.stream().collect(Collectors.mapping(CSVRecord::toList, Collectors.toList()));
        }
        Assertions.assertEquals((int)3, (int)content.size());
        Assertions.assertEquals((Object)"1", ((List)content.get(0)).get(0));
        Assertions.assertEquals((Object)"abc", ((List)content.get(0)).get(1));
        Assertions.assertEquals((Object)"test line 1\ntest line 2", ((List)content.get(0)).get(2));
        Assertions.assertNull(((List)content.get(0)).get(3));
        Assertions.assertEquals((Object)"", ((List)content.get(0)).get(4));
        Assertions.assertEquals((Object)"2", ((List)content.get(1)).get(0));
        Assertions.assertEquals((Object)"\\b:\b \\t:\t \\n:\n \\r:\r", ((List)content.get(1)).get(2));
        Assertions.assertEquals((Object)"3", ((List)content.get(2)).get(0));
        Assertions.assertEquals((Object)"b,c,d", ((List)content.get(2)).get(2));
        Assertions.assertEquals((Object)"\"quoted\"", ((List)content.get(2)).get(3));
    }

    @Test
    public void testPostgresqlCsv() throws Exception {
        this.testHelper("psql.csv", CSVFormat.POSTGRESQL_CSV);
    }

    @Test
    public void testPostgresqlText() throws Exception {
        this.testHelper("psql.tsv", CSVFormat.POSTGRESQL_TEXT);
    }

    @Test
    public void testWriteThenRead() throws Exception {
        StringWriter sw = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.POSTGRESQL_CSV.builder().setHeader(new String[0]).setSkipHeaderRecord(true).build());){
            printer.printRecord(new Object[]{"column1", "column2"});
            printer.printRecord(new Object[]{"v11", "v12"});
            printer.printRecord(new Object[]{"v21", "v22"});
            printer.close();
            CSVParser parser = new CSVParser((Reader)new StringReader(sw.toString()), CSVFormat.POSTGRESQL_CSV.builder().setHeader(new String[0]).setSkipHeaderRecord(true).build());
            Assertions.assertArrayEquals((Object[])new Object[]{"column1", "column2"}, (Object[])parser.getHeaderNames().toArray());
            Iterator i = parser.iterator();
            Assertions.assertArrayEquals((Object[])new String[]{"v11", "v12"}, (Object[])((CSVRecord)i.next()).toList().toArray());
            Assertions.assertArrayEquals((Object[])new String[]{"v21", "v22"}, (Object[])((CSVRecord)i.next()).toList().toArray());
        }
    }
}

