/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv203Test {
    @Test
    public void testQuoteModeAll() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setNullString("N/A").setIgnoreSurroundingSpaces(true).setQuoteMode(QuoteMode.ALL).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{null, "Hello", null, "World"});
        }
        Assertions.assertEquals((Object)"\"N/A\",\"Hello\",\"N/A\",\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testQuoteModeAllNonNull() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setNullString("N/A").setIgnoreSurroundingSpaces(true).setQuoteMode(QuoteMode.ALL_NON_NULL).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{null, "Hello", null, "World"});
        }
        Assertions.assertEquals((Object)"N/A,\"Hello\",N/A,\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testQuoteModeMinimal() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setNullString("N/A").setIgnoreSurroundingSpaces(true).setQuoteMode(QuoteMode.MINIMAL).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{null, "Hello", null, "World"});
        }
        Assertions.assertEquals((Object)"N/A,Hello,N/A,World\r\n", (Object)buffer.toString());
    }

    @Test
    public void testQuoteModeNonNumeric() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setNullString("N/A").setIgnoreSurroundingSpaces(true).setQuoteMode(QuoteMode.NON_NUMERIC).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{null, "Hello", null, "World"});
        }
        Assertions.assertEquals((Object)"N/A,\"Hello\",N/A,\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testWithEmptyValues() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setNullString("N/A").setIgnoreSurroundingSpaces(true).setQuoteMode(QuoteMode.ALL).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{"", "Hello", "", "World"});
        }
        Assertions.assertEquals((Object)"\"\",\"Hello\",\"\",\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testWithoutNullString() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setIgnoreSurroundingSpaces(true).setQuoteMode(QuoteMode.ALL).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{null, "Hello", null, "World"});
        }
        Assertions.assertEquals((Object)",\"Hello\",,\"World\"\r\n", (Object)buffer.toString());
    }

    @Test
    public void testWithoutQuoteMode() throws Exception {
        CSVFormat format = CSVFormat.EXCEL.builder().setNullString("N/A").setIgnoreSurroundingSpaces(true).build();
        StringBuilder buffer = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, format);){
            printer.printRecord(new Object[]{null, "Hello", null, "World"});
        }
        Assertions.assertEquals((Object)"N/A,Hello,N/A,World\r\n", (Object)buffer.toString());
    }
}

