/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.configuration2.tree.xpath.XPathContextFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestXPathContextFactory {
    private XPathContextFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new XPathContextFactory();
    }

    @Test
    public void testCreateContext() {
        ImmutableNode node = new ImmutableNode.Builder().name("testRoot").create();
        NodeHandler handler = new InMemoryNodeModel(node).getNodeHandler();
        JXPathContext context = this.factory.createContext((Object)node, handler);
        Assert.assertTrue((String)"No lenient mode", (boolean)context.isLenient());
        ConfigurationNodePointerFactory.NodeWrapper wrapper = (ConfigurationNodePointerFactory.NodeWrapper)context.getContextBean();
        Assert.assertSame((String)"Wrong node", (Object)node, (Object)wrapper.getNode());
        Assert.assertSame((String)"Wrong handler", (Object)handler, (Object)wrapper.getNodeHandler());
    }
}

