/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiFileBuilderParametersImpl;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMultiFileBuilderParametersImpl {
    private MultiFileBuilderParametersImpl params;

    @Before
    public void setUp() throws Exception {
        this.params = new MultiFileBuilderParametersImpl();
    }

    @Test
    public void testFromParatersNotFound() {
        Assert.assertNull((String)"Got an instance", (Object)MultiFileBuilderParametersImpl.fromParameters(new HashMap()));
    }

    @Test
    public void testFromParametersFound() {
        Map map = this.params.getParameters();
        Assert.assertSame((String)"Instance not found", (Object)this.params, (Object)MultiFileBuilderParametersImpl.fromParameters((Map)map, (boolean)true));
    }

    @Test
    public void testFromParametersNewInstance() {
        this.params = MultiFileBuilderParametersImpl.fromParameters(new HashMap(), (boolean)true);
        Assert.assertNotNull((String)"No new instance", (Object)this.params);
    }

    @Test
    public void testSetFilePattern() {
        String pattern = "somePattern";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setFilePattern(pattern));
        Assert.assertEquals((String)"Pattern not set", (Object)pattern, (Object)this.params.getFilePattern());
    }

    @Test
    public void testSetManagedBuilderParameters() {
        BuilderParameters bp = (BuilderParameters)EasyMock.createMock(BuilderParameters.class);
        EasyMock.replay((Object[])new Object[]{bp});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setManagedBuilderParameters(bp));
        Assert.assertSame((String)"Parameters not set", (Object)bp, (Object)this.params.getManagedBuilderParameters());
    }

    @Test
    public void testBeanProperties() throws Exception {
        BuilderParameters bp = (BuilderParameters)EasyMock.createMock(BuilderParameters.class);
        EasyMock.replay((Object[])new Object[]{bp});
        String pattern = "testPattern";
        BeanHelper.setProperty((Object)this.params, (String)"filePattern", (Object)pattern);
        BeanHelper.setProperty((Object)this.params, (String)"managedBuilderParameters", (Object)bp);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        Map map = this.params.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assert.assertSame((String)"Wrong parameters instance", (Object)this.params, (Object)MultiFileBuilderParametersImpl.fromParameters((Map)map));
        Assert.assertEquals((String)"Wrong pattern", (Object)pattern, (Object)this.params.getFilePattern());
        Assert.assertSame((String)"Wrong managed parameters", (Object)bp, (Object)this.params.getManagedBuilderParameters());
    }

    @Test
    public void testClone() {
        FileBasedBuilderParametersImpl managedParams = new FileBasedBuilderParametersImpl();
        managedParams.setFileName("test.xml");
        this.params.setManagedBuilderParameters((BuilderParameters)managedParams);
        this.params.setFilePattern("somePattern");
        MultiFileBuilderParametersImpl clone = this.params.clone();
        Assert.assertEquals((String)"Wrong pattern", (Object)this.params.getFilePattern(), (Object)clone.getFilePattern());
        Assert.assertNotSame((String)"Managed parameters not cloned", (Object)this.params.getManagedBuilderParameters(), (Object)clone.getManagedBuilderParameters());
        Assert.assertEquals((String)"Wrong file name", (Object)managedParams.getFileHandler().getFileName(), (Object)((FileBasedBuilderParametersImpl)clone.getManagedBuilderParameters()).getFileHandler().getFileName());
    }
}

