/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileSystem;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestFileBasedBuilderParameters {
    @Test
    public void testInitDefaults() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertFalse((String)"Got a location", (boolean)params.getFileHandler().isLocationDefined());
        Assert.assertNull((String)"Got a refresh delay", (Object)params.getReloadingRefreshDelay());
    }

    @Test
    public void testInitFileHandler() {
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl(handler);
        Assert.assertSame((String)"Wrong handler", (Object)handler, (Object)params.getFileHandler());
    }

    @Test
    public void testSetReloadingRefreshDelay() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Long delay = 10000L;
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setReloadingRefreshDelay(delay));
        Assert.assertEquals((String)"Wrong delay", (Object)delay, (Object)params.getReloadingRefreshDelay());
    }

    @Test
    public void testSetReloadingDetectorFactory() {
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)EasyMock.createMock(ReloadingDetectorFactory.class);
        EasyMock.replay((Object[])new Object[]{factory});
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertNull((String)"Got a factory", (Object)params.getReloadingDetectorFactory());
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setReloadingDetectorFactory(factory));
        Assert.assertSame((String)"Factory not set", (Object)factory, (Object)params.getReloadingDetectorFactory());
    }

    @Test
    public void testSetFile() {
        File file = ConfigurationAssert.getTestFile("test.properties").getAbsoluteFile();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setFile(file));
        Assert.assertEquals((String)"Wrong file", (Object)file, (Object)params.getFileHandler().getFile());
    }

    @Test
    public void testSetURL() {
        URL url = ConfigurationAssert.getTestURL("test.properties");
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setURL(url));
        Assert.assertEquals((String)"Wrong URL", (Object)url.toExternalForm(), (Object)params.getFileHandler().getURL().toExternalForm());
    }

    @Test
    public void testSetPath() {
        String path = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setPath(path));
        Assert.assertEquals((String)"Wrong path", (Object)path, (Object)params.getFileHandler().getPath());
    }

    @Test
    public void testSetFileName() {
        String name = "testConfig.xml";
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setFileName(name));
        Assert.assertEquals((String)"Wrong name", (Object)name, (Object)params.getFileHandler().getFileName());
    }

    @Test
    public void testSetBasePath() {
        String path = ConfigurationAssert.getTestFile("test.properties").getParentFile().getAbsolutePath();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setBasePath(path));
        Assert.assertEquals((String)"Wrong path", (Object)path, (Object)params.getFileHandler().getBasePath());
    }

    @Test
    public void testSetFileSystem() {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{fs});
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setFileSystem(fs));
        Assert.assertSame((String)"Wrong file system", (Object)fs, (Object)params.getFileHandler().getFileSystem());
    }

    @Test
    public void testSetLocationStrategy() {
        FileLocationStrategy strat = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        EasyMock.replay((Object[])new Object[]{strat});
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setLocationStrategy(strat));
        Assert.assertSame((String)"Wrong location strategy", (Object)strat, (Object)params.getFileHandler().getLocationStrategy());
    }

    @Test
    public void testSetEncoding() {
        String enc = "ISO-8859-1";
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setEncoding(enc));
        Assert.assertSame((String)"Wrong encoding", (Object)enc, (Object)params.getFileHandler().getEncoding());
    }

    @Test
    public void testGetParameters() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setReloadingRefreshDelay(Long.valueOf(1000L));
        params.setThrowExceptionOnMissing(true);
        Map map = params.getParameters();
        Assert.assertTrue((String)"Object not stored", (boolean)map.values().contains(params));
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, params.getParameters().get("throwExceptionOnMissing"));
    }

    @Test
    public void testFromParametersNotFound() {
        Assert.assertNull((String)"Got an instance", (Object)FileBasedBuilderParametersImpl.fromParameters(new HashMap()));
    }

    @Test
    public void testFromParametersDefaultInstance() {
        FileBasedBuilderParametersImpl params = FileBasedBuilderParametersImpl.fromParameters(new HashMap(), (boolean)true);
        Assert.assertFalse((String)"Got a location", (boolean)params.getFileHandler().isLocationDefined());
    }

    @Test
    public void testFromParametersExtract() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Map map = params.getParameters();
        Assert.assertSame((String)"Wrong parameters", (Object)params, (Object)FileBasedBuilderParametersImpl.fromParameters((Map)map));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromParametersNull() {
        FileBasedBuilderParametersImpl.fromParameters(null);
    }

    @Test
    public void testBeanPropertiesAccess() throws Exception {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        BeanHelper.setProperty((Object)params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        BeanHelper.setProperty((Object)params, (String)"fileName", (Object)"test.xml");
        Assert.assertEquals((String)"File name not set", (Object)"test.xml", (Object)params.getFileHandler().getFileName());
        Map map = params.getParameters();
        Assert.assertEquals((String)"Property not stored", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    public void testClone() {
        FileBased content = (FileBased)EasyMock.createMock(FileBased.class);
        EasyMock.replay((Object[])new Object[]{content});
        FileHandler fh = new FileHandler(content);
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl(fh);
        params.setThrowExceptionOnMissing(true);
        params.setFileName("test.xml");
        FileBasedBuilderParametersImpl clone = params.clone();
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, clone.getParameters().get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"File name not copied", (Object)"test.xml", (Object)clone.getFileHandler().getFileName());
        Assert.assertSame((String)"Content not copied", (Object)content, (Object)clone.getFileHandler().getContent());
        Assert.assertNotSame((String)"No copy of file handler", (Object)params.getFileHandler(), (Object)clone.getFileHandler());
    }

    @Test
    public void testFromMap() {
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)EasyMock.createMock(ReloadingDetectorFactory.class);
        EasyMock.replay((Object[])new Object[]{factory});
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fileName = "someFileName";
        String basePath = "someBasePath";
        Long refreshDelay = 20140628222302L;
        map.put("basePath", "someBasePath");
        map.put("fileName", "someFileName");
        map.put("reloadingDetectorFactory", factory);
        map.put("reloadingRefreshDelay", refreshDelay);
        FileBasedBuilderParametersImpl params = FileBasedBuilderParametersImpl.fromMap(map);
        Assert.assertEquals((String)"Wrong base path", (Object)"someBasePath", (Object)params.getFileHandler().getBasePath());
        Assert.assertEquals((String)"Wrong file name", (Object)"someFileName", (Object)params.getFileHandler().getFileName());
        Assert.assertEquals((String)"Wrong detector factory", (Object)factory, (Object)params.getReloadingDetectorFactory());
        Assert.assertEquals((String)"Wrong refresh delay", (Object)refreshDelay, (Object)params.getReloadingRefreshDelay());
    }

    @Test
    public void testFromMapNull() {
        FileBasedBuilderParametersImpl params = FileBasedBuilderParametersImpl.fromMap(null);
        Assert.assertNull((String)"Got refresh delay", (Object)params.getReloadingRefreshDelay());
        Assert.assertNull((String)"Got a file name", (Object)params.getFileHandler().getFileName());
    }

    @Test
    public void testInheritFrom() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        params.setEncoding("ISO-8856-1");
        params.setPath("A path");
        params.setReloadingDetectorFactory((ReloadingDetectorFactory)EasyMock.createMock(ReloadingDetectorFactory.class));
        params.setFileSystem((FileSystem)EasyMock.createMock(FileSystem.class));
        params.setLocationStrategy((FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class));
        params.setReloadingRefreshDelay(Long.valueOf(20160213171737L));
        params.setThrowExceptionOnMissing(true);
        FileBasedBuilderParametersImpl params2 = new FileBasedBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Assert.assertEquals((String)"Encoding not set", (Object)params.getFileHandler().getEncoding(), (Object)params2.getFileHandler().getEncoding());
        Assert.assertEquals((String)"File system not set", (Object)params.getFileHandler().getFileSystem(), (Object)params2.getFileHandler().getFileSystem());
        Assert.assertEquals((String)"Location strategy not set", (Object)params.getFileHandler().getLocationStrategy(), (Object)params2.getFileHandler().getLocationStrategy());
        Assert.assertEquals((String)"Detector factory not set", (Object)params.getReloadingDetectorFactory(), (Object)params2.getReloadingDetectorFactory());
        Assert.assertEquals((String)"Refresh delay not set", (Object)params.getReloadingRefreshDelay(), (Object)params2.getReloadingRefreshDelay());
        Assert.assertNull((String)"Path was copied", (Object)params2.getFileHandler().getPath());
        Assert.assertEquals((String)"Base properties not set", (Object)Boolean.TRUE, params2.getParameters().get("throwExceptionOnMissing"));
    }

    @Test
    public void testInheritFromSkipMissingProperties() {
        String encoding = "UTF-16";
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)EasyMock.createMock(ReloadingDetectorFactory.class);
        Long refreshDelay = 20160213172611L;
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setEncoding(encoding).setReloadingDetectorFactory(factory).setReloadingRefreshDelay(refreshDelay);
        params.inheritFrom(new FileBasedBuilderParametersImpl().getParameters());
        Assert.assertEquals((String)"Encoding overwritten", (Object)encoding, (Object)params.getFileHandler().getEncoding());
        Assert.assertEquals((String)"Detector factory overwritten", (Object)factory, (Object)params.getReloadingDetectorFactory());
        Assert.assertEquals((String)"Refresh delay overwritten", (Object)refreshDelay, (Object)params.getReloadingRefreshDelay());
    }

    @Test
    public void testInheritFromNoParametersObject() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setReloadingRefreshDelay(Long.valueOf(20160213211429L));
        params.inheritFrom(new HashMap());
        Assert.assertNotNull((String)"Properties were overwritten", (Object)params.getReloadingRefreshDelay());
    }
}

