/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cocoon.configuration.Settings;

public class MutableSettings
implements Settings {
    protected boolean readOnly = false;
    protected static final String KEYPREFIX = "org.apache.cocoon.";
    protected final Properties properties = new Properties();
    protected boolean reloadingEnabled;
    protected final List loadClasses = new ArrayList();
    protected String cacheDirectory;
    protected String workDirectory;
    protected String formEncoding;
    protected long configurationReloadDelay;
    protected long creationTime;
    protected String containerEncoding;
    protected Settings parent;
    protected final String runningMode;

    public MutableSettings(String mode) {
        this.reloadingEnabled = false;
        this.configurationReloadDelay = 1000L;
        this.containerEncoding = "ISO-8859-1";
        this.runningMode = mode;
    }

    public MutableSettings(Settings parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent is not allowed to be null.");
        }
        this.parent = parent;
        this.runningMode = parent.getRunningMode();
    }

    public void configure(Properties props) {
        this.checkWriteable();
        if (props != null) {
            Iterator<Map.Entry<Object, Object>> i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> current = i.next();
                String key = current.getKey().toString();
                if (!key.startsWith(KEYPREFIX)) continue;
                String value = current.getValue().toString();
                if (key.equals("org.apache.cocoon.reload-delay")) {
                    this.setConfigurationReloadDelay(Long.valueOf(value));
                    continue;
                }
                if (key.equals("org.apache.cocoon.reloading")) {
                    this.setReloadingEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals("org.apache.cocoon.cache.directory")) {
                    this.setCacheDirectory(value);
                    continue;
                }
                if (key.equals("org.apache.cocoon.work.directory")) {
                    this.setWorkDirectory(value);
                    continue;
                }
                if (key.equals("org.apache.cocoon.formencoding")) {
                    this.setFormEncoding(value);
                    continue;
                }
                if (key.startsWith("org.apache.cocoon.classloader.load.classes")) {
                    this.addToLoadClasses(value);
                    continue;
                }
                if (!key.startsWith("org.apache.cocoon.containerencoding")) continue;
                this.setContainerEncoding(value);
            }
            this.properties.putAll((Map<?, ?>)props);
        }
    }

    public boolean isReloadingEnabled(String type) {
        if (type == null) {
            if (this.parent != null) {
                return this.parent.isReloadingEnabled(type);
            }
            return this.reloadingEnabled;
        }
        String o = this.getProperty("org.apache.cocoon.reloading." + type);
        if (o != null) {
            return Boolean.valueOf(o);
        }
        if (this.parent != null) {
            return this.parent.isReloadingEnabled(type);
        }
        return this.reloadingEnabled;
    }

    public String getCacheDirectory() {
        if (this.parent != null) {
            return this.parent.getCacheDirectory();
        }
        return this.cacheDirectory;
    }

    public String getFormEncoding() {
        if (this.parent != null) {
            return this.parent.getFormEncoding();
        }
        return this.formEncoding;
    }

    public String getContainerEncoding() {
        if (this.parent != null) {
            return this.parent.getContainerEncoding();
        }
        return this.containerEncoding;
    }

    public void setContainerEncoding(String value) {
        this.checkSubSetting();
        this.containerEncoding = value;
    }

    public List getLoadClasses() {
        return this.loadClasses;
    }

    public String getWorkDirectory() {
        if (this.parent != null) {
            return this.parent.getWorkDirectory();
        }
        return this.workDirectory;
    }

    public long getReloadDelay(String type) {
        if (type == null) {
            if (this.parent != null) {
                return this.parent.getReloadDelay(type);
            }
            return this.configurationReloadDelay;
        }
        String o = this.getProperty("org.apache.cocoon.reload-delay." + type);
        if (o != null) {
            return Long.valueOf(o);
        }
        if (this.parent != null) {
            return this.parent.getReloadDelay(type);
        }
        return this.configurationReloadDelay;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = null;
        if (key.startsWith(KEYPREFIX)) {
            if (key.equals("org.apache.cocoon.reload-delay")) {
                value = String.valueOf(this.getReloadDelay(null));
            } else if (key.equals("org.apache.cocoon.reloading")) {
                value = String.valueOf(this.isReloadingEnabled(null));
            } else if (key.equals("org.apache.cocoon.cache.directory")) {
                value = this.getCacheDirectory();
            } else if (key.equals("org.apache.cocoon.work.directory")) {
                value = this.getWorkDirectory();
            } else if (key.equals("org.apache.cocoon.formencoding")) {
                value = this.getFormEncoding();
            } else if (key.equals("org.apache.cocoon.classloader.load.classes")) {
                value = this.toString(this.getLoadClasses());
            } else if (key.equals("org.apache.cocoon.containerencoding")) {
                value = this.containerEncoding;
            }
        }
        if (value == null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = this.parent != null ? this.parent.getProperty(key, defaultValue) : defaultValue;
        }
        return value;
    }

    public String toString() {
        return "Settings:\nRunning mode : " + this.getRunningMode() + '\n' + "org.apache.cocoon.reload-delay" + " : " + this.getReloadDelay(null) + '\n' + "org.apache.cocoon.reloading" + " : " + this.isReloadingEnabled(null) + '\n' + "org.apache.cocoon.classloader.load.classes" + " : " + this.toString(this.getLoadClasses()) + '\n' + "org.apache.cocoon.cache.directory" + " : " + this.getCacheDirectory() + '\n' + "org.apache.cocoon.work.directory" + " : " + this.getWorkDirectory() + '\n' + "org.apache.cocoon.formencoding" + " : " + this.getFormEncoding() + '\n' + "org.apache.cocoon.containerencoding" + " : " + this.getContainerEncoding() + '\n';
    }

    protected String toString(List a) {
        StringBuffer buffer = new StringBuffer();
        Iterator i = a.iterator();
        boolean first = true;
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(i.next());
        }
        return buffer.toString();
    }

    public void setReloadingEnabled(boolean allowReload) {
        this.checkWriteable();
        this.checkSubSetting();
        this.reloadingEnabled = allowReload;
    }

    public void setCacheDirectory(String cacheDirectory) {
        this.checkWriteable();
        this.checkSubSetting();
        this.cacheDirectory = cacheDirectory;
    }

    public void setFormEncoding(String formEncoding) {
        this.checkWriteable();
        this.checkSubSetting();
        this.formEncoding = formEncoding;
    }

    public void addToLoadClasses(String className) {
        this.checkWriteable();
        this.loadClasses.add(className);
    }

    public void setWorkDirectory(String workDirectory) {
        this.checkWriteable();
        this.checkSubSetting();
        this.workDirectory = workDirectory;
    }

    public void setConfigurationReloadDelay(long configurationReloadDelay) {
        this.checkWriteable();
        this.checkSubSetting();
        this.configurationReloadDelay = configurationReloadDelay;
    }

    public void makeReadOnly() {
        this.readOnly = false;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.readOnly) {
            throw new IllegalStateException("Settings is read only and can not be modified anymore.");
        }
    }

    protected final void checkSubSetting() throws IllegalStateException {
        if (this.parent != null) {
            throw new IllegalStateException("This value can only be changed for the root settings object.");
        }
    }

    public long getCreationTime() {
        if (this.parent != null) {
            return this.parent.getCreationTime();
        }
        return this.creationTime;
    }

    public void setCreationTime(long value) {
        this.checkSubSetting();
        this.creationTime = value;
    }

    public List getPropertyNames(String keyPrefix) {
        ArrayList<String> props = new ArrayList<String>();
        Iterator<Object> kI = this.properties.keySet().iterator();
        while (kI.hasNext()) {
            String name = (String)kI.next();
            if (!name.startsWith(keyPrefix) || props.contains(name)) continue;
            props.add(name);
        }
        if (this.parent != null) {
            List parentList = this.parent.getPropertyNames(keyPrefix);
            Iterator i = parentList.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (props.contains(name)) continue;
                props.add(name);
            }
        }
        return props;
    }

    public List getPropertyNames() {
        ArrayList<String> props = new ArrayList<String>();
        Iterator<Object> kI = this.properties.keySet().iterator();
        while (kI.hasNext()) {
            String name = (String)kI.next();
            if (props.contains(name)) continue;
            props.add(name);
        }
        if (this.parent != null) {
            List parentList = this.parent.getPropertyNames();
            Iterator i = parentList.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (props.contains(name)) continue;
                props.add(name);
            }
        }
        return props;
    }

    public String getRunningMode() {
        return this.runningMode;
    }
}

